/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.BitMixer;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.IntCursor;
import org.graylog.shaded.opensearch2.org.apache.lucene.internal.hppc.IntIntHashMap;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.FrozenIntSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.IntSet;

final class StateSet
extends IntSet {
    private final IntIntHashMap inner;
    private long hashCode;
    private boolean hashUpdated = true;
    private boolean arrayUpdated = true;
    private int[] arrayCache = new int[0];

    StateSet(int capacity) {
        this.inner = new IntIntHashMap(capacity);
    }

    void incr(int state) {
        if (this.inner.addTo(state, 1) == 1) {
            this.keyChanged();
        }
    }

    void decr(int state) {
        assert (this.inner.containsKey(state));
        int keyIndex = this.inner.indexOf(state);
        int count = this.inner.indexGet(keyIndex) - 1;
        if (count == 0) {
            this.inner.indexRemove(keyIndex);
            this.keyChanged();
        } else {
            this.inner.indexReplace(keyIndex, count);
        }
    }

    FrozenIntSet freeze(int state) {
        return new FrozenIntSet(this.getArray(), this.longHashCode(), state);
    }

    private void keyChanged() {
        this.hashUpdated = false;
        this.arrayUpdated = false;
    }

    @Override
    int[] getArray() {
        if (this.arrayUpdated) {
            return this.arrayCache;
        }
        this.arrayCache = new int[this.inner.size()];
        int i = 0;
        for (IntCursor key : this.inner.keys()) {
            this.arrayCache[i++] = key.value;
        }
        Arrays.sort(this.arrayCache);
        this.arrayUpdated = true;
        return this.arrayCache;
    }

    @Override
    int size() {
        return this.inner.size();
    }

    @Override
    long longHashCode() {
        if (this.hashUpdated) {
            return this.hashCode;
        }
        this.hashCode = this.inner.size();
        for (IntCursor key : this.inner.keys()) {
            this.hashCode += (long)BitMixer.mix(key.value);
        }
        this.hashUpdated = true;
        return this.hashCode;
    }
}

