/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.crypto;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class CryptoSettings
implements Writeable,
ToXContentObject {
    private String keyProviderName;
    private String keyProviderType;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;

    public CryptoSettings(StreamInput in) throws IOException {
        this.keyProviderName = in.readString();
        this.keyProviderType = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
    }

    public CryptoSettings(String keyProviderName) {
        this.keyProviderName = keyProviderName;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.keyProviderName == null) {
            validationException = ValidateActions.addValidationError("key_provider_name is missing", validationException);
        }
        if (this.keyProviderType == null) {
            validationException = ValidateActions.addValidationError("key_provider_type is missing", validationException);
        }
        return validationException;
    }

    public String getKeyProviderName() {
        return this.keyProviderName;
    }

    public String getKeyProviderType() {
        return this.keyProviderType;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public CryptoSettings keyProviderName(String keyProviderName) {
        this.keyProviderName = keyProviderName;
        return this;
    }

    public CryptoSettings keyProviderType(String keyProviderType) {
        this.keyProviderType = keyProviderType;
        return this;
    }

    public CryptoSettings settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public CryptoSettings settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public CryptoSettings settings(Map<String, Object> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public CryptoSettings(Map<String, Object> cryptoDefinition) {
        for (Map.Entry<String, Object> entry : cryptoDefinition.entrySet()) {
            if (entry.getKey().equals("key_provider_name")) {
                this.keyProviderName(entry.getValue().toString());
                continue;
            }
            if (entry.getKey().equals("key_provider_type")) {
                this.keyProviderType(entry.getValue().toString());
                continue;
            }
            if (!entry.getKey().equals("settings")) continue;
            if (!(entry.getValue() instanceof Map)) {
                throw new IllegalArgumentException("Malformed settings section in crypto settings, should include an inner object");
            }
            Map sub = (Map)entry.getValue();
            this.settings(sub);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.keyProviderName);
        out.writeString(this.keyProviderType);
        Settings.writeSettingsToStream(this.settings, out);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("key_provider_name", this.keyProviderName);
        builder.field("key_provider_type", this.keyProviderType);
        builder.startObject("settings");
        this.settings.toXContent(builder, params);
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

