/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.tasks.cancel;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.opensearch.ResourceNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.TaskOperationFailure;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.tasks.TransportTasksAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.CancellableTask;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskInfo;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportCancelTasksAction
extends TransportTasksAction<CancellableTask, CancelTasksRequest, CancelTasksResponse, TaskInfo> {
    @Inject
    public TransportCancelTasksAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super("cluster:admin/tasks/cancel", clusterService, transportService, actionFilters, CancelTasksRequest::new, CancelTasksResponse::new, TaskInfo::new, "management");
    }

    @Override
    protected CancelTasksResponse newResponse(CancelTasksRequest request, List<TaskInfo> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        return new CancelTasksResponse(tasks, taskOperationFailures, failedNodeExceptions);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processTasks(CancelTasksRequest request, Consumer<CancellableTask> operation) {
        if (request.getTaskId().isSet()) {
            CancellableTask task = this.taskManager.getCancellableTask(request.getTaskId().getId());
            if (task != null) {
                if (!request.match(task)) throw new IllegalArgumentException("task [" + String.valueOf(request.getTaskId()) + "] doesn't support this operation");
                operation.accept(task);
                return;
            }
            if (this.taskManager.getTask(request.getTaskId().getId()) != null) {
                throw new IllegalArgumentException("task [" + String.valueOf(request.getTaskId()) + "] doesn't support cancellation");
            }
            throw new ResourceNotFoundException("task [{}] is not found", request.getTaskId());
        }
        Iterator<CancellableTask> iterator = this.taskManager.getCancellableTasks().values().iterator();
        while (iterator.hasNext()) {
            CancellableTask task = iterator.next();
            if (!request.match(task)) continue;
            operation.accept(task);
        }
    }

    @Override
    protected void taskOperation(CancelTasksRequest request, CancellableTask cancellableTask, ActionListener<TaskInfo> listener) {
        String nodeId = this.clusterService.localNode().getId();
        this.taskManager.cancelTaskAndDescendants(cancellableTask, request.getReason(), request.waitForCompletion(), ActionListener.map(listener, r -> cancellableTask.taskInfo(nodeId, false)));
    }
}

