/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.IndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeReadRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.search.slice.SliceBuilder;

@PublicApi(since="1.0.0")
public class ClusterSearchShardsRequest
extends ClusterManagerNodeReadRequest<ClusterSearchShardsRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private IndicesOptions indicesOptions = IndicesOptions.lenientExpandOpen();
    @Nullable
    private SliceBuilder sliceBuilder;

    public ClusterSearchShardsRequest() {
    }

    public ClusterSearchShardsRequest(String ... indices) {
        this.indices(indices);
    }

    public ClusterSearchShardsRequest(StreamInput in) throws IOException {
        super(in);
        boolean hasSlice;
        this.indices = in.readStringArray();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getVersion().onOrAfter(Version.V_2_19_0) && (hasSlice = in.readBoolean())) {
            this.sliceBuilder = new SliceBuilder(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().onOrAfter(Version.V_2_19_0)) {
            if (this.sliceBuilder != null) {
                out.writeBoolean(true);
                this.sliceBuilder.writeTo(out);
            } else {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public ClusterSearchShardsRequest indices(String ... indices) {
        Objects.requireNonNull(indices, "indices must not be null");
        for (int i = 0; i < indices.length; ++i) {
            Objects.requireNonNull(indices[i], "indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ClusterSearchShardsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public String routing() {
        return this.routing;
    }

    public ClusterSearchShardsRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public ClusterSearchShardsRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public ClusterSearchShardsRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public ClusterSearchShardsRequest slice(SliceBuilder sliceBuilder) {
        this.sliceBuilder = sliceBuilder;
        return this;
    }

    public SliceBuilder slice() {
        return this.sliceBuilder;
    }
}

