/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.shards.routing.weighted.put;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchGenerationException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.WeightedRouting;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.DeprecationHandler;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaType;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.NamedXContentRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="2.4.0")
public class ClusterPutWeightedRoutingRequest
extends ClusterManagerNodeRequest<ClusterPutWeightedRoutingRequest> {
    private static final Logger logger = LogManager.getLogger(ClusterPutWeightedRoutingRequest.class);
    private WeightedRouting weightedRouting;
    private String attributeName;
    private long version;

    public void version(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public ClusterPutWeightedRoutingRequest() {
    }

    public WeightedRouting getWeightedRouting() {
        return this.weightedRouting;
    }

    public ClusterPutWeightedRoutingRequest setWeightedRouting(WeightedRouting weightedRouting) {
        this.weightedRouting = weightedRouting;
        return this;
    }

    public void attributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public ClusterPutWeightedRoutingRequest(StreamInput in) throws IOException {
        super(in);
        this.weightedRouting = new WeightedRouting(in);
        this.version = in.readLong();
    }

    public ClusterPutWeightedRoutingRequest(String attributeName) {
        this.attributeName = attributeName;
    }

    public void setWeightedRouting(Map<String, Object> source) {
        try {
            if (source.isEmpty()) {
                throw new OpenSearchParseException("Empty request body", new Object[0]);
            }
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.map(source);
            this.setWeightedRouting(BytesReference.bytes(builder), builder.contentType());
        }
        catch (IOException e) {
            throw new OpenSearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public void setWeightedRouting(BytesReference source, MediaType contentType) {
        try (XContentParser parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, source, contentType);){
            XContentParser.Token token;
            String attrValue = null;
            HashMap<String, Double> weights = new HashMap<String, Double>();
            Double attrWeight = null;
            parser.nextToken();
            String versionAttr = null;
            long version = -2L;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    if (fieldName != null && fieldName.equals("_version")) {
                        versionAttr = parser.currentName();
                        continue;
                    }
                    if (fieldName == null || !fieldName.equals("weights")) {
                        throw new OpenSearchParseException("failed to parse weighted routing request object [{}]", fieldName);
                    }
                    String weightsAttr = parser.currentName();
                    if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
                        throw new OpenSearchParseException("failed to parse weighted routing request object  [{}], expected object", weightsAttr);
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            attrValue = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            attrWeight = Double.parseDouble(parser.text());
                            weights.put(attrValue, attrWeight);
                            continue;
                        }
                        throw new OpenSearchParseException("failed to parse weighted routing request attribute [{}], unknown type", attrWeight);
                    }
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (versionAttr == null || !versionAttr.equals("_version")) continue;
                    version = parser.longValue();
                    continue;
                }
                throw new OpenSearchParseException("failed to parse weighted routing request [{}], unknown type", this.attributeName);
            }
            this.weightedRouting = new WeightedRouting(this.attributeName, weights);
            this.version = version;
        }
        catch (IOException e) {
            logger.error("error while parsing put weighted routing request object", (Throwable)e);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.weightedRouting == null) {
            validationException = ValidateActions.addValidationError("Weighted routing request object is null", validationException);
        }
        if (this.weightedRouting.attributeName() == null || this.weightedRouting.attributeName().isEmpty()) {
            validationException = ValidateActions.addValidationError("Attribute name is missing", validationException);
        }
        if (this.weightedRouting.weights() == null || this.weightedRouting.weights().isEmpty()) {
            validationException = ValidateActions.addValidationError("Weights are missing", validationException);
        }
        if (this.version == -2L) {
            validationException = ValidateActions.addValidationError("Version is missing", validationException);
        }
        int countValueWithZeroWeights = 0;
        try {
            for (Double value : this.weightedRouting.weights().values()) {
                if (value == null) {
                    validationException = ValidateActions.addValidationError("Weight is null", validationException);
                    continue;
                }
                double weight = Double.parseDouble(((Object)value).toString());
                countValueWithZeroWeights = weight == 0.0 ? countValueWithZeroWeights + 1 : countValueWithZeroWeights;
            }
        }
        catch (NumberFormatException e) {
            validationException = ValidateActions.addValidationError("Weight is not a number", validationException);
        }
        if (validationException != null) {
            return validationException;
        }
        if (countValueWithZeroWeights > this.weightedRouting.weights().size() / 2) {
            validationException = ValidateActions.addValidationError(String.format(Locale.ROOT, "There are too many attribute values [%s] given zero weight [%d]. Maximum expected number of routing weights having zero weight is [%d]", this.weightedRouting.weights().toString(), countValueWithZeroWeights, this.weightedRouting.weights().size() / 2), null);
        }
        return validationException;
    }

    public ClusterPutWeightedRoutingRequest source(Map<String, Object> source) {
        this.setWeightedRouting(source);
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.weightedRouting.writeTo(out);
        out.writeLong(this.version);
    }

    public String toString() {
        return "ClusterPutWeightedRoutingRequest{weightedRouting= " + this.weightedRouting.toString() + "version= " + this.version + "}";
    }
}

