/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentType;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.support.XContentMapValues;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class RestoreSnapshotRequest
extends ClusterManagerNodeRequest<RestoreSnapshotRequest>
implements ToXContentObject {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(RestoreSnapshotRequest.class);
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private String renamePattern;
    private String renameReplacement;
    private String renameAliasPattern;
    private String renameAliasReplacement;
    private boolean waitForCompletion;
    private boolean includeGlobalState = false;
    private boolean partial = false;
    private boolean includeAliases = true;
    private Settings indexSettings = Settings.Builder.EMPTY_SETTINGS;
    private String[] ignoreIndexSettings = Strings.EMPTY_ARRAY;
    private StorageType storageType = StorageType.LOCAL;
    @Nullable
    private String sourceRemoteStoreRepository = null;
    @Nullable
    private String sourceRemoteTranslogRepository = null;
    @Nullable
    private String snapshotUuid;

    public RestoreSnapshotRequest() {
    }

    public RestoreSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    public RestoreSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.renamePattern = in.readOptionalString();
        this.renameReplacement = in.readOptionalString();
        this.waitForCompletion = in.readBoolean();
        this.includeGlobalState = in.readBoolean();
        this.partial = in.readBoolean();
        this.includeAliases = in.readBoolean();
        if (in.getVersion().before(LegacyESVersion.V_7_7_0)) {
            Settings.readSettingsFromStream(in);
        }
        this.indexSettings = Settings.readSettingsFromStream(in);
        this.ignoreIndexSettings = in.readStringArray();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            this.snapshotUuid = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_2_7_0)) {
            this.storageType = in.readEnum(StorageType.class);
        }
        if (in.getVersion().onOrAfter(Version.V_2_10_0)) {
            this.sourceRemoteStoreRepository = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.sourceRemoteTranslogRepository = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_2_18_0)) {
            this.renameAliasPattern = in.readOptionalString();
        }
        if (in.getVersion().onOrAfter(Version.V_2_18_0)) {
            this.renameAliasReplacement = in.readOptionalString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.renamePattern);
        out.writeOptionalString(this.renameReplacement);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.partial);
        out.writeBoolean(this.includeAliases);
        if (out.getVersion().before(LegacyESVersion.V_7_7_0)) {
            Settings.writeSettingsToStream(Settings.EMPTY, out);
        }
        Settings.writeSettingsToStream(this.indexSettings, out);
        out.writeStringArray(this.ignoreIndexSettings);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            out.writeOptionalString(this.snapshotUuid);
        } else if (this.snapshotUuid != null) {
            throw new IllegalStateException("restricting the snapshot UUID is forbidden in a cluster with version [" + String.valueOf(out.getVersion()) + "] nodes");
        }
        if (out.getVersion().onOrAfter(Version.V_2_7_0)) {
            out.writeEnum(this.storageType);
        }
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeOptionalString(this.sourceRemoteStoreRepository);
        }
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeOptionalString(this.sourceRemoteTranslogRepository);
        }
        if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
            out.writeOptionalString(this.renameAliasPattern);
        }
        if (out.getVersion().onOrAfter(Version.V_2_18_0)) {
            out.writeOptionalString(this.renameAliasReplacement);
        }
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices are missing", validationException);
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is missing", validationException);
        }
        if (this.indexSettings == null) {
            validationException = ValidateActions.addValidationError("indexSettings are missing", validationException);
        }
        if (this.ignoreIndexSettings == null) {
            validationException = ValidateActions.addValidationError("ignoreIndexSettings are missing", validationException);
        }
        return validationException;
    }

    public RestoreSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public RestoreSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public RestoreSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public RestoreSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[0]);
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public RestoreSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public RestoreSnapshotRequest renamePattern(String renamePattern) {
        this.renamePattern = renamePattern;
        return this;
    }

    public String renamePattern() {
        return this.renamePattern;
    }

    public RestoreSnapshotRequest renameReplacement(String renameReplacement) {
        this.renameReplacement = renameReplacement;
        return this;
    }

    public String renameReplacement() {
        return this.renameReplacement;
    }

    public RestoreSnapshotRequest renameAliasPattern(String renameAliasPattern) {
        this.renameAliasPattern = renameAliasPattern;
        return this;
    }

    public String renameAliasPattern() {
        return this.renameAliasPattern;
    }

    public RestoreSnapshotRequest renameAliasReplacement(String renameAliasReplacement) {
        this.renameAliasReplacement = renameAliasReplacement;
        return this;
    }

    public String renameAliasReplacement() {
        return this.renameAliasReplacement;
    }

    public RestoreSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public boolean partial() {
        return this.partial;
    }

    public RestoreSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(String ... ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings;
        return this;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(List<String> ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings.toArray(new String[0]);
        return this;
    }

    public String[] ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public RestoreSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public RestoreSnapshotRequest includeAliases(boolean includeAliases) {
        this.includeAliases = includeAliases;
        return this;
    }

    public boolean includeAliases() {
        return this.includeAliases;
    }

    public RestoreSnapshotRequest indexSettings(Settings settings) {
        this.indexSettings = settings;
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Settings.Builder settings) {
        this.indexSettings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(String source, XContentType xContentType) {
        this.indexSettings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Map<String, Object> source) {
        this.indexSettings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    public Settings indexSettings() {
        return this.indexSettings;
    }

    public RestoreSnapshotRequest snapshotUuid(String snapshotUuid) {
        this.snapshotUuid = snapshotUuid;
        return this;
    }

    @Nullable
    public String snapshotUuid() {
        return this.snapshotUuid;
    }

    public RestoreSnapshotRequest storageType(StorageType storageType) {
        this.storageType = storageType;
        return this;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public RestoreSnapshotRequest setSourceRemoteStoreRepository(String sourceRemoteStoreRepository) {
        this.sourceRemoteStoreRepository = sourceRemoteStoreRepository;
        return this;
    }

    public RestoreSnapshotRequest setSourceRemoteTranslogRepository(String sourceRemoteTranslogRepository) {
        this.sourceRemoteTranslogRepository = sourceRemoteTranslogRepository;
        return this;
    }

    public String getSourceRemoteStoreRepository() {
        return this.sourceRemoteStoreRepository;
    }

    public String getSourceRemoteTranslogRepository() {
        return this.sourceRemoteTranslogRepository;
    }

    public RestoreSnapshotRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayList) {
                    this.indices((ArrayList)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (name.equals("partial")) {
                this.partial(XContentMapValues.nodeBooleanValue(entry.getValue(), "partial"));
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed settings section");
                }
                DEPRECATION_LOGGER.deprecate("RestoreSnapshotRequest#settings", "specifying [settings] when restoring a snapshot has no effect and will not be supported in a future version", new Object[0]);
                continue;
            }
            if (name.equals("include_global_state")) {
                this.includeGlobalState = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_global_state");
                continue;
            }
            if (name.equals("include_aliases")) {
                this.includeAliases = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_aliases");
                continue;
            }
            if (name.equals("rename_pattern")) {
                if (entry.getValue() instanceof String) {
                    this.renamePattern((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_pattern");
            }
            if (name.equals("rename_replacement")) {
                if (entry.getValue() instanceof String) {
                    this.renameReplacement((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_replacement");
            }
            if (name.equals("rename_alias_pattern")) {
                if (entry.getValue() instanceof String) {
                    this.renameAliasPattern((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_alias_pattern");
            }
            if (name.equals("rename_alias_replacement")) {
                if (entry.getValue() instanceof String) {
                    this.renameAliasReplacement((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_alias_replacement");
            }
            if (name.equals("index_settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed index_settings section");
                }
                this.indexSettings((Map)entry.getValue());
                continue;
            }
            if (name.equals("ignore_index_settings")) {
                if (entry.getValue() instanceof String) {
                    this.ignoreIndexSettings(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    this.ignoreIndexSettings((List)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed ignore_index_settings section, should be an array of strings");
            }
            if (name.equals("storage_type")) {
                if (entry.getValue() instanceof String) {
                    this.storageType(StorageType.fromString((String)entry.getValue()));
                    continue;
                }
                throw new IllegalArgumentException("malformed storage_type");
            }
            if (name.equals("source_remote_store_repository")) {
                if (entry.getValue() instanceof String) {
                    this.setSourceRemoteStoreRepository((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed source_remote_store_repository");
            }
            if (name.equals("source_remote_translog_repository")) {
                if (entry.getValue() instanceof String) {
                    this.setSourceRemoteTranslogRepository((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed source_remote_translog_repository");
            }
            if (IndicesOptions.isIndicesOptions(name)) continue;
            throw new IllegalArgumentException("Unknown parameter " + name);
        }
        this.indicesOptions(IndicesOptions.fromMap(source, this.indicesOptions));
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("indices");
        for (String index : this.indices) {
            builder.value(index);
        }
        builder.endArray();
        if (this.indicesOptions != null) {
            this.indicesOptions.toXContent(builder, params);
        }
        if (this.renamePattern != null) {
            builder.field("rename_pattern", this.renamePattern);
        }
        if (this.renameReplacement != null) {
            builder.field("rename_replacement", this.renameReplacement);
        }
        if (this.renameAliasPattern != null) {
            builder.field("rename_alias_pattern", this.renameAliasPattern);
        }
        if (this.renameAliasReplacement != null) {
            builder.field("rename_alias_replacement", this.renameAliasReplacement);
        }
        builder.field("include_global_state", this.includeGlobalState);
        builder.field("partial", this.partial);
        builder.field("include_aliases", this.includeAliases);
        if (this.indexSettings != null) {
            builder.startObject("index_settings");
            if (!this.indexSettings.isEmpty()) {
                this.indexSettings.toXContent(builder, params);
            }
            builder.endObject();
        }
        builder.startArray("ignore_index_settings");
        for (String ignoreIndexSetting : this.ignoreIndexSettings) {
            builder.value(ignoreIndexSetting);
        }
        builder.endArray();
        if (this.storageType != null) {
            this.storageType.toXContent(builder);
        }
        if (this.sourceRemoteStoreRepository != null) {
            builder.field("source_remote_store_repository", this.sourceRemoteStoreRepository);
        }
        if (this.sourceRemoteTranslogRepository != null) {
            builder.field("source_remote_translog_repository", this.sourceRemoteTranslogRepository);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotRequest that = (RestoreSnapshotRequest)o;
        boolean equals = this.waitForCompletion == that.waitForCompletion && this.includeGlobalState == that.includeGlobalState && this.partial == that.partial && this.includeAliases == that.includeAliases && Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Arrays.equals(this.indices, that.indices) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.renamePattern, that.renamePattern) && Objects.equals(this.renameReplacement, that.renameReplacement) && Objects.equals(this.renameAliasPattern, that.renameAliasPattern) && Objects.equals(this.renameAliasReplacement, that.renameAliasReplacement) && Objects.equals(this.indexSettings, that.indexSettings) && Arrays.equals(this.ignoreIndexSettings, that.ignoreIndexSettings) && Objects.equals(this.snapshotUuid, that.snapshotUuid) && Objects.equals((Object)this.storageType, (Object)that.storageType) && Objects.equals(this.sourceRemoteStoreRepository, that.sourceRemoteStoreRepository) && Objects.equals(this.sourceRemoteTranslogRepository, that.sourceRemoteTranslogRepository);
        return equals;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.snapshot, this.repository, this.indicesOptions, this.renamePattern, this.renameReplacement, this.renameAliasPattern, this.renameAliasReplacement, this.waitForCompletion, this.includeGlobalState, this.partial, this.includeAliases, this.indexSettings, this.snapshotUuid, this.storageType, this.sourceRemoteStoreRepository, this.sourceRemoteTranslogRepository});
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.ignoreIndexSettings);
        return result;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    @PublicApi(since="1.0.0")
    public static enum StorageType {
        LOCAL("local"),
        REMOTE_SNAPSHOT("remote_snapshot");

        private final String text;

        private StorageType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        private void toXContent(XContentBuilder builder) throws IOException {
            builder.field("storage_type", this.text);
        }

        private static StorageType fromString(String string) {
            for (StorageType type : StorageType.values()) {
                if (!type.text.equals(string)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid storage_type: " + string);
        }
    }
}

