/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.ClusterManagerNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class SnapshotsStatusRequest
extends ClusterManagerNodeRequest<SnapshotsStatusRequest> {
    private String repository = "_all";
    private String[] snapshots = Strings.EMPTY_ARRAY;
    private String[] indices = Strings.EMPTY_ARRAY;
    private boolean ignoreUnavailable;

    public SnapshotsStatusRequest() {
    }

    public SnapshotsStatusRequest(String repository, String[] snapshots) {
        this.repository = repository;
        this.snapshots = snapshots;
    }

    public SnapshotsStatusRequest(String repository, String[] snapshots, String[] indices) {
        this.repository = repository;
        this.snapshots = snapshots;
        this.indices = indices;
    }

    public SnapshotsStatusRequest(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readString();
        this.snapshots = in.readStringArray();
        this.ignoreUnavailable = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.indices = in.readOptionalStringArray();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.repository);
        out.writeStringArray(this.snapshots);
        out.writeBoolean(this.ignoreUnavailable);
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeOptionalStringArray(this.indices);
        }
    }

    public SnapshotsStatusRequest(String repository) {
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.snapshots == null) {
            validationException = ValidateActions.addValidationError("snapshots is null", validationException);
        }
        if (this.indices.length != 0) {
            if (this.repository.equals("_all")) {
                String error = "index list filter is supported only when a single 'repository' is passed, but found 'repository' param = [_all]";
                validationException = ValidateActions.addValidationError(error, validationException);
            }
            if (this.snapshots.length != 1) {
                String snapshotParamValue = this.snapshots.length == 0 ? "_all" : Arrays.toString(this.snapshots);
                String error = "index list filter is supported only when a single 'snapshot' is passed, but found 'snapshot' param = [" + snapshotParamValue + "]";
                validationException = ValidateActions.addValidationError(error, validationException);
            }
        }
        return validationException;
    }

    public SnapshotsStatusRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public String[] snapshots() {
        return this.snapshots;
    }

    public SnapshotsStatusRequest snapshots(String[] snapshots) {
        this.snapshots = snapshots;
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public SnapshotsStatusRequest indices(String[] indices) {
        this.indices = indices;
        return this;
    }

    public SnapshotsStatusRequest ignoreUnavailable(boolean ignoreUnavailable) {
        this.ignoreUnavailable = ignoreUnavailable;
        return this;
    }

    public boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }
}

