/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.stats.NodeStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.ClusterStatsNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.ClusterStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.ClusterStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats.CommonStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats.CommonStatsFlags;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats.ShardStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterStateHealth;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.CommitStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.RetentionLeaseStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.seqno.SeqNoStats;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeService;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transports;

public class TransportClusterStatsAction
extends TransportNodesAction<ClusterStatsRequest, ClusterStatsResponse, ClusterStatsNodeRequest, ClusterStatsNodeResponse> {
    private static final Map<CommonStatsFlags.Flag, ClusterStatsRequest.IndexMetric> SHARDS_STATS_FLAG_MAP_TO_INDEX_METRIC = Map.of(CommonStatsFlags.Flag.Docs, ClusterStatsRequest.IndexMetric.DOCS, CommonStatsFlags.Flag.Store, ClusterStatsRequest.IndexMetric.STORE, CommonStatsFlags.Flag.FieldData, ClusterStatsRequest.IndexMetric.FIELDDATA, CommonStatsFlags.Flag.QueryCache, ClusterStatsRequest.IndexMetric.QUERY_CACHE, CommonStatsFlags.Flag.Completion, ClusterStatsRequest.IndexMetric.COMPLETION, CommonStatsFlags.Flag.Segments, ClusterStatsRequest.IndexMetric.SEGMENTS);
    private final NodeService nodeService;
    private final IndicesService indicesService;

    @Inject
    public TransportClusterStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, IndicesService indicesService, ActionFilters actionFilters) {
        super("cluster:monitor/stats", threadPool, clusterService, transportService, actionFilters, ClusterStatsRequest::new, ClusterStatsNodeRequest::new, "management", "management", ClusterStatsNodeResponse.class);
        this.nodeService = nodeService;
        this.indicesService = indicesService;
    }

    @Override
    protected ClusterStatsResponse newResponse(ClusterStatsRequest request, List<ClusterStatsNodeResponse> responses, List<FailedNodeException> failures) {
        assert (Transports.assertNotTransportThread("Constructor of ClusterStatsResponse runs expensive computations on mappings found in the cluster state that are too slow for a transport thread"));
        ClusterState state = this.clusterService.state();
        if (request.computeAllMetrics()) {
            return new ClusterStatsResponse(System.currentTimeMillis(), state.metadata().clusterUUID(), this.clusterService.getClusterName(), responses, failures, state);
        }
        return new ClusterStatsResponse(System.currentTimeMillis(), state.metadata().clusterUUID(), this.clusterService.getClusterName(), responses, failures, state, request.requestedMetrics(), request.indicesMetrics());
    }

    @Override
    protected ClusterStatsNodeRequest newNodeRequest(ClusterStatsRequest request) {
        return new ClusterStatsNodeRequest(request);
    }

    @Override
    protected ClusterStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new ClusterStatsNodeResponse(in);
    }

    @Override
    protected ClusterStatsNodeResponse nodeOperation(ClusterStatsNodeRequest nodeRequest) {
        NodeInfo nodeInfo = this.nodeService.info(true, true, false, true, false, true, false, true, false, false, false, false);
        NodeStats nodeStats = this.nodeService.stats(CommonStatsFlags.NONE, this.isMetricRequired(ClusterStatsRequest.Metric.OS, nodeRequest.request), this.isMetricRequired(ClusterStatsRequest.Metric.PROCESS, nodeRequest.request), this.isMetricRequired(ClusterStatsRequest.Metric.JVM, nodeRequest.request), false, this.isMetricRequired(ClusterStatsRequest.Metric.FS, nodeRequest.request), false, false, false, false, false, this.isMetricRequired(ClusterStatsRequest.Metric.INGEST, nodeRequest.request), false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        ArrayList<ShardStats> shardsStats = new ArrayList<ShardStats>();
        if (this.isMetricRequired(ClusterStatsRequest.Metric.INDICES, nodeRequest.request)) {
            CommonStatsFlags commonStatsFlags = TransportClusterStatsAction.getCommonStatsFlags(nodeRequest);
            for (IndexService indexService : this.indicesService) {
                for (IndexShard indexShard : indexService) {
                    RetentionLeaseStats retentionLeaseStats;
                    SeqNoStats seqNoStats;
                    CommitStats commitStats;
                    if (indexShard.routingEntry() == null || !indexShard.routingEntry().active()) continue;
                    try {
                        commitStats = indexShard.commitStats();
                        seqNoStats = indexShard.seqNoStats();
                        retentionLeaseStats = indexShard.getRetentionLeaseStats();
                    }
                    catch (AlreadyClosedException e) {
                        commitStats = null;
                        seqNoStats = null;
                        retentionLeaseStats = null;
                    }
                    shardsStats.add(new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(this.indicesService.getIndicesQueryCache(), indexShard, commonStatsFlags), commitStats, seqNoStats, retentionLeaseStats));
                }
            }
        }
        ClusterHealthStatus clusterStatus = null;
        if (this.clusterService.state().nodes().isLocalNodeElectedClusterManager()) {
            clusterStatus = new ClusterStateHealth(this.clusterService.state(), ClusterHealthRequest.Level.CLUSTER).getStatus();
        }
        return new ClusterStatsNodeResponse(nodeInfo.getNode(), clusterStatus, nodeInfo, nodeStats, shardsStats.toArray(new ShardStats[0]), nodeRequest.request.useAggregatedNodeLevelResponses());
    }

    private boolean isMetricRequired(ClusterStatsRequest.Metric metric, ClusterStatsRequest clusterStatsRequest) {
        return clusterStatsRequest.computeAllMetrics() || clusterStatsRequest.requestedMetrics().contains((Object)metric);
    }

    private static CommonStatsFlags getCommonStatsFlags(ClusterStatsNodeRequest nodeRequest) {
        HashSet<CommonStatsFlags.Flag> requestedCommonStatsFlags = new HashSet<CommonStatsFlags.Flag>();
        if (nodeRequest.request.computeAllMetrics()) {
            requestedCommonStatsFlags.addAll(SHARDS_STATS_FLAG_MAP_TO_INDEX_METRIC.keySet());
        } else {
            for (Map.Entry<CommonStatsFlags.Flag, ClusterStatsRequest.IndexMetric> entry : SHARDS_STATS_FLAG_MAP_TO_INDEX_METRIC.entrySet()) {
                if (!nodeRequest.request.indicesMetrics().contains((Object)entry.getValue())) continue;
                requestedCommonStatsFlags.add(entry.getKey());
            }
        }
        return new CommonStatsFlags(requestedCommonStatsFlags.toArray(new CommonStatsFlags.Flag[0]));
    }

    public static class ClusterStatsNodeRequest
    extends BaseNodeRequest {
        protected ClusterStatsRequest request;

        public ClusterStatsNodeRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new ClusterStatsRequest(in);
        }

        ClusterStatsNodeRequest(ClusterStatsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

