/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.wlm;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.wlm.WlmStatsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.wlm.WlmStatsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupService;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.stats.WlmStats;

public class TransportWlmStatsAction
extends TransportNodesAction<WlmStatsRequest, WlmStatsResponse, NodeWlmStatsRequest, WlmStats> {
    final QueryGroupService queryGroupService;

    @Inject
    public TransportWlmStatsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, QueryGroupService queryGroupService, ActionFilters actionFilters) {
        super("cluster:monitor/wlm/stats", threadPool, clusterService, transportService, actionFilters, WlmStatsRequest::new, NodeWlmStatsRequest::new, "management", WlmStats.class);
        this.queryGroupService = queryGroupService;
    }

    @Override
    protected WlmStatsResponse newResponse(WlmStatsRequest request, List<WlmStats> wlmStats, List<FailedNodeException> failures) {
        return new WlmStatsResponse(this.clusterService.getClusterName(), wlmStats, failures);
    }

    @Override
    protected NodeWlmStatsRequest newNodeRequest(WlmStatsRequest request) {
        return new NodeWlmStatsRequest(request);
    }

    @Override
    protected WlmStats newNodeResponse(StreamInput in) throws IOException {
        return new WlmStats(in);
    }

    @Override
    protected WlmStats nodeOperation(NodeWlmStatsRequest nodeWlmStatsRequest) {
        assert (this.transportService.getLocalNode() != null);
        WlmStatsRequest request = nodeWlmStatsRequest.request;
        return new WlmStats(this.transportService.getLocalNode(), this.queryGroupService.nodeStats(request.getQueryGroupIds(), request.isBreach()));
    }

    public static class NodeWlmStatsRequest
    extends BaseNodeRequest {
        protected WlmStatsRequest request;

        public NodeWlmStatsRequest(StreamInput in) throws IOException {
            super(in);
            this.request = new WlmStatsRequest(in);
        }

        NodeWlmStatsRequest(WlmStatsRequest request) {
            this.request = request;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }

        public DiscoveryNode[] getDiscoveryNodes() {
            return this.request.concreteNodes();
        }
    }
}

