/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.wlm;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

@ExperimentalApi
public class WlmStatsRequest
extends BaseNodesRequest<WlmStatsRequest> {
    private final Set<String> queryGroupIds;
    private final Boolean breach;

    public WlmStatsRequest(StreamInput in) throws IOException {
        super(in);
        this.queryGroupIds = new HashSet<String>(Set.of(in.readStringArray()));
        this.breach = in.readOptionalBoolean();
    }

    public WlmStatsRequest(String[] nodesIds, Set<String> queryGroupIds, Boolean breach) {
        super(false, nodesIds);
        this.queryGroupIds = queryGroupIds;
        this.breach = breach;
    }

    public WlmStatsRequest() {
        super(false, (String[])null);
        this.queryGroupIds = new HashSet<String>();
        this.breach = false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.queryGroupIds.toArray(new String[0]));
        out.writeOptionalBoolean(this.breach);
    }

    public Set<String> getQueryGroupIds() {
        return this.queryGroupIds;
    }

    public Boolean isBreach() {
        return this.breach;
    }
}

