/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.alias.get;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.AliasMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.DeprecationLogger;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.indices.SystemIndices;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportGetAliasesAction
extends TransportClusterManagerNodeReadAction<GetAliasesRequest, GetAliasesResponse> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TransportGetAliasesAction.class);
    private final SystemIndices systemIndices;

    @Inject
    public TransportGetAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SystemIndices systemIndices) {
        super("indices:admin/aliases/get", transportService, clusterService, threadPool, actionFilters, GetAliasesRequest::new, indexNameExpressionResolver, true);
        this.systemIndices = systemIndices;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(GetAliasesRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNamesWithSystemIndexAccess(state, request));
    }

    @Override
    protected GetAliasesResponse read(StreamInput in) throws IOException {
        return new GetAliasesResponse(in);
    }

    @Override
    protected void clusterManagerOperation(GetAliasesRequest request, ClusterState state, ActionListener<GetAliasesResponse> listener) {
        String[] concreteIndices;
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().newStoredContext(false);){
            concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        }
        boolean systemIndexAccessAllowed = this.indexNameExpressionResolver.isSystemIndexAccessAllowed();
        Map<String, List<AliasMetadata>> aliases = state.metadata().findAliases(request, concreteIndices);
        listener.onResponse(new GetAliasesResponse(TransportGetAliasesAction.postProcess(request, concreteIndices, aliases, state, systemIndexAccessAllowed, this.systemIndices)));
    }

    static Map<String, List<AliasMetadata>> postProcess(GetAliasesRequest request, String[] concreteIndices, Map<String, List<AliasMetadata>> aliases, ClusterState state, boolean systemIndexAccessAllowed, SystemIndices systemIndices) {
        boolean noAliasesSpecified = request.getOriginalAliases() == null || request.getOriginalAliases().length == 0;
        HashMap<String, List<AliasMetadata>> mapBuilder = new HashMap<String, List<AliasMetadata>>(aliases);
        for (String index : concreteIndices) {
            if (aliases.get(index) != null || !noAliasesSpecified) continue;
            List previous = mapBuilder.put(index, Collections.emptyList());
            assert (previous == null);
        }
        Map<String, List<AliasMetadata>> finalResponse = Collections.unmodifiableMap(mapBuilder);
        if (!systemIndexAccessAllowed) {
            TransportGetAliasesAction.checkSystemIndexAccess(request, systemIndices, state, finalResponse);
        }
        return finalResponse;
    }

    private static void checkSystemIndexAccess(GetAliasesRequest request, SystemIndices systemIndices, ClusterState state, Map<String, List<AliasMetadata>> aliasesMap) {
        HashSet<String> systemIndicesNames = new HashSet<String>();
        for (String indexName : aliasesMap.keySet()) {
            IndexMetadata index = state.metadata().index(indexName);
            if (index == null || !index.isSystem()) continue;
            systemIndicesNames.add(indexName);
        }
        if (!systemIndicesNames.isEmpty()) {
            systemIndicesNames.forEach(systemIndexName -> deprecationLogger.deprecate("open_system_index_access_" + systemIndexName, "this request accesses system indices: [{}], but in a future major version, direct access to system indices will be prevented by default", systemIndexName));
        } else {
            TransportGetAliasesAction.checkSystemAliasAccess(request, systemIndices);
        }
    }

    private static void checkSystemAliasAccess(GetAliasesRequest request, SystemIndices systemIndices) {
        List systemAliases = Arrays.stream(request.aliases()).filter(alias -> systemIndices.isSystemIndex((String)alias)).collect(Collectors.toList());
        if (!systemAliases.isEmpty()) {
            deprecationLogger.deprecate("open_system_alias_access", "this request accesses aliases with names reserved for system indices: {}, but in a future major version, directaccess to system indices and their aliases will not be allowed", systemAliases);
        }
    }
}

