/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.cache.clear;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardsIterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardPath;
import org.graylog.shaded.opensearch2.org.opensearch.indices.IndicesService;
import org.graylog.shaded.opensearch2.org.opensearch.node.Node;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportClearIndicesCacheAction
extends TransportBroadcastByNodeAction<ClearIndicesCacheRequest, ClearIndicesCacheResponse, TransportBroadcastByNodeAction.EmptyResult> {
    private final IndicesService indicesService;
    private final Node node;

    @Inject
    public TransportClearIndicesCacheAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, Node node, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:admin/cache/clear", clusterService, transportService, actionFilters, indexNameExpressionResolver, ClearIndicesCacheRequest::new, "management", false);
        this.indicesService = indicesService;
        this.node = node;
    }

    @Override
    protected TransportBroadcastByNodeAction.EmptyResult readShardResult(StreamInput in) throws IOException {
        return TransportBroadcastByNodeAction.EmptyResult.readEmptyResultFrom(in);
    }

    @Override
    protected ClearIndicesCacheResponse newResponse(ClearIndicesCacheRequest request, int totalShards, int successfulShards, int failedShards, List<TransportBroadcastByNodeAction.EmptyResult> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new ClearIndicesCacheResponse(totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected ClearIndicesCacheRequest readRequestFrom(StreamInput in) throws IOException {
        return new ClearIndicesCacheRequest(in);
    }

    @Override
    protected TransportBroadcastByNodeAction.EmptyResult shardOperation(ClearIndicesCacheRequest request, ShardRouting shardRouting) {
        if (request.fileCache() && this.node.fileCache() != null) {
            ShardPath shardPath = ShardPath.loadFileCachePath(this.node.getNodeEnvironment(), shardRouting.shardId());
            Predicate<Path> pathStartsWithShardPathPredicate = path -> path.startsWith(shardPath.getDataPath());
            this.node.fileCache().prune(pathStartsWithShardPathPredicate);
        }
        this.indicesService.clearIndexShardCache(shardRouting.shardId(), request.queryCache(), request.fieldDataCache(), request.requestCache(), request.fields());
        return TransportBroadcastByNodeAction.EmptyResult.INSTANCE;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, ClearIndicesCacheRequest request, String[] concreteIndices) {
        return clusterState.routingTable().allShards(concreteIndices);
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, ClearIndicesCacheRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, ClearIndicesCacheRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }
}

