/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.FailedNodeException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.DanglingIndexInfo;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list.ListDanglingIndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list.ListDanglingIndicesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list.NodeListDanglingIndicesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.dangling.list.NodeListDanglingIndicesResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.TransportNodesAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.gateway.DanglingIndicesState;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportListDanglingIndicesAction
extends TransportNodesAction<ListDanglingIndicesRequest, ListDanglingIndicesResponse, NodeListDanglingIndicesRequest, NodeListDanglingIndicesResponse> {
    private final TransportService transportService;
    private final DanglingIndicesState danglingIndicesState;

    @Inject
    public TransportListDanglingIndicesAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DanglingIndicesState danglingIndicesState) {
        super("cluster:admin/indices/dangling/list", threadPool, clusterService, transportService, actionFilters, ListDanglingIndicesRequest::new, NodeListDanglingIndicesRequest::new, "management", NodeListDanglingIndicesResponse.class);
        this.transportService = transportService;
        this.danglingIndicesState = danglingIndicesState;
    }

    @Override
    protected ListDanglingIndicesResponse newResponse(ListDanglingIndicesRequest request, List<NodeListDanglingIndicesResponse> nodeListDanglingIndicesResponse, List<FailedNodeException> failures) {
        return new ListDanglingIndicesResponse(this.clusterService.getClusterName(), nodeListDanglingIndicesResponse, failures);
    }

    @Override
    protected NodeListDanglingIndicesRequest newNodeRequest(ListDanglingIndicesRequest request) {
        return new NodeListDanglingIndicesRequest(request.getIndexUUID());
    }

    @Override
    protected NodeListDanglingIndicesResponse newNodeResponse(StreamInput in) throws IOException {
        return new NodeListDanglingIndicesResponse(in);
    }

    @Override
    protected NodeListDanglingIndicesResponse nodeOperation(NodeListDanglingIndicesRequest request) {
        DiscoveryNode localNode = this.transportService.getLocalNode();
        ArrayList<DanglingIndexInfo> indexMetaData = new ArrayList<DanglingIndexInfo>();
        String indexFilter = request.getIndexUUID();
        for (IndexMetadata each : this.danglingIndicesState.getDanglingIndices().values()) {
            if (indexFilter != null && !indexFilter.equals(each.getIndexUUID())) continue;
            DanglingIndexInfo danglingIndexInfo = new DanglingIndexInfo(localNode.getId(), each.getIndex().getName(), each.getIndexUUID(), each.getCreationDate());
            indexMetaData.add(danglingIndexInfo);
        }
        return new NodeListDanglingIndicesResponse(localNode, indexMetaData);
    }
}

