/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.flush;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.BroadcastRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class FlushRequest
extends BroadcastRequest<FlushRequest> {
    private boolean force = false;
    private boolean waitIfOngoing = true;

    public FlushRequest(String ... indices) {
        super(indices);
    }

    public FlushRequest(StreamInput in) throws IOException {
        super(in);
        this.force = in.readBoolean();
        this.waitIfOngoing = in.readBoolean();
    }

    public boolean waitIfOngoing() {
        return this.waitIfOngoing;
    }

    public FlushRequest waitIfOngoing(boolean waitIfOngoing) {
        this.waitIfOngoing = waitIfOngoing;
        return this;
    }

    public boolean force() {
        return this.force;
    }

    public FlushRequest force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationError = super.validate();
        if (this.force && !this.waitIfOngoing) {
            validationError = ValidateActions.addValidationError("wait_if_ongoing must be true for a force flush", validationError);
        }
        return validationError;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.force);
        out.writeBoolean(this.waitIfOngoing);
    }

    public String toString() {
        return "FlushRequest{waitIfOngoing=" + this.waitIfOngoing + ", force=" + this.force + "}";
    }
}

