/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.forcemerge;

import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.BroadcastRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.UUIDs;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;

@PublicApi(since="1.0.0")
public class ForceMergeRequest
extends BroadcastRequest<ForceMergeRequest> {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private boolean primaryOnly = false;
    private static final Version FORCE_MERGE_UUID_VERSION = LegacyESVersion.V_7_7_0;
    @Nullable
    private final String forceMergeUUID;
    private boolean shouldStoreResult;

    public ForceMergeRequest(String ... indices) {
        super(indices);
        this.forceMergeUUID = UUIDs.randomBase64UUID();
    }

    public ForceMergeRequest(StreamInput in) throws IOException {
        super(in);
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_2_13_0)) {
            this.primaryOnly = in.readBoolean();
        }
        this.forceMergeUUID = in.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION) ? in.readOptionalString() : null;
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public ForceMergeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public ForceMergeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    @Nullable
    public String forceMergeUUID() {
        return this.forceMergeUUID;
    }

    public boolean flush() {
        return this.flush;
    }

    public ForceMergeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    public boolean primaryOnly() {
        return this.primaryOnly;
    }

    public ForceMergeRequest primaryOnly(boolean primaryOnly) {
        this.primaryOnly = primaryOnly;
        return this;
    }

    public void setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
    }

    @Override
    public boolean getShouldStoreResult() {
        return this.shouldStoreResult;
    }

    @Override
    public String getDescription() {
        return "Force-merge indices " + Arrays.toString(this.indices()) + ", maxSegments[" + this.maxNumSegments + "], onlyExpungeDeletes[" + this.onlyExpungeDeletes + "], flush[" + this.flush + "], primaryOnly[" + this.primaryOnly + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(Version.V_2_13_0)) {
            out.writeBoolean(this.primaryOnly);
        }
        if (out.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION)) {
            out.writeOptionalString(this.forceMergeUUID);
        }
    }

    public String toString() {
        return "ForceMergeRequest{maxNumSegments=" + this.maxNumSegments + ", onlyExpungeDeletes=" + this.onlyExpungeDeletes + ", flush=" + this.flush + ", primaryOnly=" + this.primaryOnly + "}";
    }

    public static final class Defaults {
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
        public static final boolean PRIMARY_ONLY = false;
    }
}

