/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentHelper;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class GetFieldMappingsResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ObjectParser<Map<String, Map<String, FieldMappingMetadata>>, String> PARSER = new ObjectParser(MAPPINGS.getPreferredName(), true, HashMap::new);
    private final Map<String, Map<String, FieldMappingMetadata>> mappings;

    GetFieldMappingsResponse(Map<String, Map<String, FieldMappingMetadata>> mappings) {
        this.mappings = mappings;
    }

    GetFieldMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        HashMap indexMapBuilder = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int typesSize = in.readVInt();
                if (typesSize == 0) {
                    indexMapBuilder.put(index, Collections.emptyMap());
                    continue;
                }
                if (typesSize != 1) {
                    throw new IllegalStateException("Expected single type but received [" + typesSize + "]");
                }
                in.readString();
            }
            int fieldSize = in.readVInt();
            HashMap<String, FieldMappingMetadata> fieldMapBuilder = new HashMap<String, FieldMappingMetadata>(fieldSize);
            for (int k = 0; k < fieldSize; ++k) {
                fieldMapBuilder.put(in.readString(), new FieldMappingMetadata(in.readString(), in.readBytesReference()));
            }
            indexMapBuilder.put(index, Collections.unmodifiableMap(fieldMapBuilder));
        }
        this.mappings = Collections.unmodifiableMap(indexMapBuilder);
    }

    public Map<String, Map<String, FieldMappingMetadata>> mappings() {
        return this.mappings;
    }

    public FieldMappingMetadata fieldMappings(String index, String field) {
        Map<String, FieldMappingMetadata> indexMapping = this.mappings.get(index);
        if (indexMapping == null) {
            return null;
        }
        return indexMapping.get(field);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Map.Entry<String, Map<String, FieldMappingMetadata>> indexEntry : this.mappings.entrySet()) {
            builder.startObject(indexEntry.getKey());
            builder.startObject(MAPPINGS.getPreferredName());
            if (this.mappings != null) {
                this.addFieldMappingsToBuilder(builder, params, indexEntry.getValue());
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private void addFieldMappingsToBuilder(XContentBuilder builder, ToXContent.Params params, Map<String, FieldMappingMetadata> mappings) throws IOException {
        for (Map.Entry<String, FieldMappingMetadata> fieldEntry : mappings.entrySet()) {
            builder.startObject(fieldEntry.getKey());
            fieldEntry.getValue().toXContent(builder, params);
            builder.endObject();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, Map<String, FieldMappingMetadata>> indexEntry : this.mappings.entrySet()) {
            out.writeString(indexEntry.getKey());
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(1);
                out.writeString("_doc");
            }
            out.writeVInt(indexEntry.getValue().size());
            for (Map.Entry<String, FieldMappingMetadata> fieldEntry : indexEntry.getValue().entrySet()) {
                out.writeString(fieldEntry.getKey());
                FieldMappingMetadata fieldMapping = fieldEntry.getValue();
                out.writeString(fieldMapping.fullName());
                out.writeBytesReference(fieldMapping.source);
            }
        }
    }

    public String toString() {
        return "GetFieldMappingsResponse{mappings=" + String.valueOf(this.mappings) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetFieldMappingsResponse)) {
            return false;
        }
        GetFieldMappingsResponse that = (GetFieldMappingsResponse)o;
        return Objects.equals(this.mappings, that.mappings);
    }

    public int hashCode() {
        return Objects.hash(this.mappings);
    }

    static {
        PARSER.declareField((p, typeMappings, index) -> {
            p.nextToken();
            while (p.currentToken() == XContentParser.Token.FIELD_NAME) {
                String typeName = p.currentName();
                if (p.nextToken() == XContentParser.Token.START_OBJECT) {
                    HashMap<String, FieldMappingMetadata> typeMapping = new HashMap<String, FieldMappingMetadata>();
                    typeMappings.put(typeName, typeMapping);
                    while (p.nextToken() == XContentParser.Token.FIELD_NAME) {
                        String fieldName = p.currentName();
                        FieldMappingMetadata fieldMappingMetadata = FieldMappingMetadata.fromXContent(p);
                        typeMapping.put(fieldName, fieldMappingMetadata);
                    }
                } else {
                    p.skipChildren();
                }
                p.nextToken();
            }
        }, MAPPINGS, ObjectParser.ValueType.OBJECT);
    }

    @PublicApi(since="1.0.0")
    public static class FieldMappingMetadata
    implements ToXContentFragment {
        private static final ParseField FULL_NAME = new ParseField("full_name", new String[0]);
        private static final ParseField MAPPING = new ParseField("mapping", new String[0]);
        private static final ConstructingObjectParser<FieldMappingMetadata, String> PARSER = new ConstructingObjectParser("field_mapping_meta_data", true, a -> new FieldMappingMetadata((String)a[0], (BytesReference)a[1]));
        private final String fullName;
        private final BytesReference source;

        public FieldMappingMetadata(String fullName, BytesReference source) {
            this.fullName = fullName;
            this.source = source;
        }

        public String fullName() {
            return this.fullName;
        }

        public Map<String, Object> sourceAsMap() {
            return XContentHelper.convertToMap(this.source, true, MediaTypeRegistry.JSON).v2();
        }

        BytesReference getSource() {
            return this.source;
        }

        public static FieldMappingMetadata fromXContent(XContentParser parser) throws IOException {
            return PARSER.parse(parser, null);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(FULL_NAME.getPreferredName(), this.fullName);
            if (params.paramAsBoolean("pretty", false)) {
                builder.field("mapping", this.sourceAsMap());
            } else {
                try (StreamInput stream = this.source.streamInput();){
                    builder.rawField(MAPPING.getPreferredName(), stream, MediaTypeRegistry.JSON);
                }
            }
            return builder;
        }

        public String toString() {
            return "FieldMappingMetadata{fullName='" + this.fullName + "', source=" + String.valueOf(this.source) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldMappingMetadata)) {
                return false;
            }
            FieldMappingMetadata that = (FieldMappingMetadata)o;
            return Objects.equals(this.fullName, that.fullName) && Objects.equals(this.source, that.source);
        }

        public int hashCode() {
            return Objects.hash(this.fullName, this.source);
        }

        static {
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.text(), FULL_NAME, ObjectParser.ValueType.STRING);
            PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().copyCurrentStructure(p);
                BytesReference bytes = BytesReference.bytes(jsonBuilder);
                return bytes;
            }, MAPPING, ObjectParser.ValueType.OBJECT);
        }
    }
}

