/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MappingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class GetMappingsResponse
extends ActionResponse
implements ToXContentFragment {
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private final Map<String, MappingMetadata> mappings;

    public GetMappingsResponse(Map<String, MappingMetadata> mappings) {
        this.mappings = Collections.unmodifiableMap(mappings);
    }

    GetMappingsResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        HashMap<String, MappingMetadata> indexMapBuilder = new HashMap<String, MappingMetadata>();
        for (int i = 0; i < size; ++i) {
            String index = in.readString();
            if (in.getVersion().before(Version.V_2_0_0)) {
                int mappingCount = in.readVInt();
                if (mappingCount == 0) {
                    indexMapBuilder.put(index, MappingMetadata.EMPTY_MAPPINGS);
                    continue;
                }
                if (mappingCount == 1) {
                    String type = in.readString();
                    if (!"_doc".equals(type)) {
                        throw new IllegalStateException("Expected _doc but got [" + type + "]");
                    }
                    indexMapBuilder.put(index, new MappingMetadata(in));
                    continue;
                }
                throw new IllegalStateException("Expected 0 or 1 mappings but got: " + mappingCount);
            }
            boolean hasMapping = in.readBoolean();
            indexMapBuilder.put(index, hasMapping ? new MappingMetadata(in) : MappingMetadata.EMPTY_MAPPINGS);
        }
        this.mappings = Collections.unmodifiableMap(indexMapBuilder);
    }

    public Map<String, MappingMetadata> mappings() {
        return this.mappings;
    }

    public Map<String, MappingMetadata> getMappings() {
        return this.mappings();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.mappings.size());
        for (Map.Entry<String, MappingMetadata> indexEntry : this.mappings.entrySet()) {
            out.writeString(indexEntry.getKey());
            if (out.getVersion().before(Version.V_2_0_0)) {
                out.writeVInt(indexEntry.getValue() == MappingMetadata.EMPTY_MAPPINGS ? 0 : 1);
                if (indexEntry.getValue() == MappingMetadata.EMPTY_MAPPINGS) continue;
                out.writeString("_doc");
                indexEntry.getValue().writeTo(out);
                continue;
            }
            out.writeOptionalWriteable(indexEntry.getValue());
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (Map.Entry<String, MappingMetadata> indexEntry : this.getMappings().entrySet()) {
            builder.startObject(indexEntry.getKey());
            if (indexEntry.getValue() != null) {
                builder.field(MAPPINGS.getPreferredName(), indexEntry.getValue().sourceAsMap());
            } else {
                builder.startObject(MAPPINGS.getPreferredName()).endObject();
            }
            builder.endObject();
        }
        return builder;
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    public int hashCode() {
        return this.mappings.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetMappingsResponse other = (GetMappingsResponse)obj;
        return this.mappings.equals(other.mappings);
    }
}

