/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.rollover.Condition;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.AbstractDiffable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class RolloverInfo
extends AbstractDiffable<RolloverInfo>
implements Writeable,
ToXContentFragment {
    public static final ParseField CONDITION_FIELD = new ParseField("met_conditions", new String[0]);
    public static final ParseField TIME_FIELD = new ParseField("time", new String[0]);
    public static final ConstructingObjectParser<RolloverInfo, String> PARSER = new ConstructingObjectParser<RolloverInfo, String>("rollover_info", false, (a, alias) -> new RolloverInfo((String)alias, (List)a[0], (Long)a[1]));
    private final String alias;
    private final List<Condition<?>> metConditions;
    private final long time;

    public RolloverInfo(String alias, List<Condition<?>> metConditions, long time) {
        this.alias = alias;
        this.metConditions = metConditions;
        this.time = time;
    }

    public RolloverInfo(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.time = in.readVLong();
        this.metConditions = in.readNamedWriteableList(Condition.class);
    }

    public static RolloverInfo parse(XContentParser parser, String alias) {
        return PARSER.apply(parser, alias);
    }

    public String getAlias() {
        return this.alias;
    }

    public List<Condition<?>> getMetConditions() {
        return this.metConditions;
    }

    public long getTime() {
        return this.time;
    }

    public static Diff<RolloverInfo> readDiffFrom(StreamInput in) throws IOException {
        return RolloverInfo.readDiffFrom(RolloverInfo::new, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias);
        out.writeVLong(this.time);
        out.writeNamedWriteableList(this.metConditions);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.alias);
        builder.startObject(CONDITION_FIELD.getPreferredName());
        for (Condition<?> condition : this.metConditions) {
            condition.toXContent(builder, params);
        }
        builder.endObject();
        builder.field(TIME_FIELD.getPreferredName(), this.time);
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.alias, this.metConditions, this.time);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RolloverInfo other = (RolloverInfo)obj;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.metConditions, other.metConditions) && Objects.equals(this.time, other.time);
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> p.namedObject(Condition.class, n, c), CONDITION_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), TIME_FIELD);
    }
}

