/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.segments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequestValidationException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ValidateActions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.broadcast.BroadcastRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="2.3.0")
public class PitSegmentsRequest
extends BroadcastRequest<PitSegmentsRequest> {
    private boolean verbose = false;
    private final List<String> pitIds = new ArrayList<String>();

    public PitSegmentsRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public PitSegmentsRequest(StreamInput in) throws IOException {
        super(in);
        this.pitIds.addAll(Arrays.asList(in.readStringArray()));
        this.verbose = in.readBoolean();
    }

    public PitSegmentsRequest(String ... pitIds) {
        super(pitIds);
        this.pitIds.addAll(Arrays.asList(pitIds));
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.pitIds == null ? null : this.pitIds.toArray(new String[0]));
        out.writeBoolean(this.verbose);
    }

    public List<String> getPitIds() {
        return Collections.unmodifiableList(this.pitIds);
    }

    public void clearAndSetPitIds(List<String> pitIds) {
        this.pitIds.clear();
        this.pitIds.addAll(pitIds);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.pitIds == null || this.pitIds.isEmpty()) {
            validationException = ValidateActions.addValidationError("no pit ids specified", validationException);
        }
        return validationException;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        this.pitIds.clear();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("pit_id".equals(currentFieldName)) {
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new IllegalArgumentException("pit_id array element should only contain PIT identifier");
                        }
                        this.pitIds.add(parser.text());
                    }
                    continue;
                }
                if (!token.isValue()) {
                    throw new IllegalArgumentException("pit_id element should only contain PIT identifier");
                }
                this.pitIds.add(parser.text());
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + String.valueOf((Object)token) + "] ");
        }
    }
}

