/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.CacheType;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public class CommonStatsFlags
implements Writeable,
Cloneable {
    public static final CommonStatsFlags ALL = new CommonStatsFlags(new Flag[0]).all();
    public static final CommonStatsFlags NONE = new CommonStatsFlags(new Flag[0]).clear();
    private EnumSet<Flag> flags = EnumSet.allOf(Flag.class);
    private String[] groups = null;
    private String[] fieldDataFields = null;
    private String[] completionDataFields = null;
    private boolean includeSegmentFileSizes = false;
    private boolean includeUnloadedSegments = false;
    private boolean includeAllShardIndexingPressureTrackers = false;
    private boolean includeOnlyTopIndexingPressureMetrics = false;
    private EnumSet<CacheType> includeCaches = EnumSet.noneOf(CacheType.class);
    private String[] levels = new String[0];
    private boolean includeIndicesStatsByLevel = false;

    public CommonStatsFlags(Flag ... flags) {
        if (flags.length > 0) {
            this.clear();
            Collections.addAll(this.flags, flags);
        }
    }

    public CommonStatsFlags(StreamInput in) throws IOException {
        long longFlags = in.readLong();
        this.flags.clear();
        for (Flag flag : Flag.values()) {
            if ((longFlags & (long)(1 << flag.getIndex())) == 0L) continue;
            this.flags.add(flag);
        }
        if (in.getVersion().before(Version.V_2_0_0)) {
            in.readStringArray();
        }
        this.groups = in.readStringArray();
        this.fieldDataFields = in.readStringArray();
        this.completionDataFields = in.readStringArray();
        this.includeSegmentFileSizes = in.readBoolean();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_2_0)) {
            this.includeUnloadedSegments = in.readBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_1_2_0)) {
            this.includeAllShardIndexingPressureTrackers = in.readBoolean();
            this.includeOnlyTopIndexingPressureMetrics = in.readBoolean();
        }
        if (in.getVersion().onOrAfter(Version.V_2_14_0)) {
            this.includeCaches = in.readEnumSet(CacheType.class);
            this.levels = in.readStringArray();
        }
        if (in.getVersion().onOrAfter(Version.V_2_17_0)) {
            this.includeIndicesStatsByLevel = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        long longFlags = 0L;
        for (Flag flag : this.flags) {
            longFlags |= (long)(1 << flag.getIndex());
        }
        out.writeLong(longFlags);
        if (out.getVersion().before(Version.V_2_0_0)) {
            out.writeStringArrayNullable(Strings.EMPTY_ARRAY);
        }
        out.writeStringArrayNullable(this.groups);
        out.writeStringArrayNullable(this.fieldDataFields);
        out.writeStringArrayNullable(this.completionDataFields);
        out.writeBoolean(this.includeSegmentFileSizes);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_2_0)) {
            out.writeBoolean(this.includeUnloadedSegments);
        }
        if (out.getVersion().onOrAfter(Version.V_1_2_0)) {
            out.writeBoolean(this.includeAllShardIndexingPressureTrackers);
            out.writeBoolean(this.includeOnlyTopIndexingPressureMetrics);
        }
        if (out.getVersion().onOrAfter(Version.V_2_14_0)) {
            out.writeEnumSet(this.includeCaches);
            out.writeStringArrayNullable(this.levels);
        }
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeBoolean(this.includeIndicesStatsByLevel);
        }
    }

    public CommonStatsFlags all() {
        this.flags = EnumSet.allOf(Flag.class);
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        this.includeSegmentFileSizes = false;
        this.includeUnloadedSegments = false;
        this.includeAllShardIndexingPressureTrackers = false;
        this.includeOnlyTopIndexingPressureMetrics = false;
        this.includeCaches = EnumSet.allOf(CacheType.class);
        this.levels = new String[0];
        return this;
    }

    public CommonStatsFlags clear() {
        this.flags = EnumSet.noneOf(Flag.class);
        this.groups = null;
        this.fieldDataFields = null;
        this.completionDataFields = null;
        this.includeSegmentFileSizes = false;
        this.includeUnloadedSegments = false;
        this.includeAllShardIndexingPressureTrackers = false;
        this.includeOnlyTopIndexingPressureMetrics = false;
        this.includeCaches = EnumSet.noneOf(CacheType.class);
        this.levels = new String[0];
        return this;
    }

    public boolean anySet() {
        return !this.flags.isEmpty();
    }

    public Flag[] getFlags() {
        return this.flags.toArray(new Flag[0]);
    }

    public Set<CacheType> getIncludeCaches() {
        return this.includeCaches;
    }

    public String[] getLevels() {
        return this.levels;
    }

    public CommonStatsFlags groups(String ... groups) {
        this.groups = groups;
        return this;
    }

    public String[] groups() {
        return this.groups;
    }

    public CommonStatsFlags fieldDataFields(String ... fieldDataFields) {
        this.fieldDataFields = fieldDataFields;
        return this;
    }

    public String[] fieldDataFields() {
        return this.fieldDataFields;
    }

    public CommonStatsFlags completionDataFields(String ... completionDataFields) {
        this.completionDataFields = completionDataFields;
        return this;
    }

    public String[] completionDataFields() {
        return this.completionDataFields;
    }

    public CommonStatsFlags includeSegmentFileSizes(boolean includeSegmentFileSizes) {
        this.includeSegmentFileSizes = includeSegmentFileSizes;
        return this;
    }

    public CommonStatsFlags includeUnloadedSegments(boolean includeUnloadedSegments) {
        this.includeUnloadedSegments = includeUnloadedSegments;
        return this;
    }

    public CommonStatsFlags includeAllShardIndexingPressureTrackers(boolean includeAllShardPressureTrackers) {
        this.includeAllShardIndexingPressureTrackers = includeAllShardPressureTrackers;
        return this;
    }

    public CommonStatsFlags includeOnlyTopIndexingPressureMetrics(boolean includeOnlyTopIndexingPressureMetrics) {
        this.includeOnlyTopIndexingPressureMetrics = includeOnlyTopIndexingPressureMetrics;
        return this;
    }

    public CommonStatsFlags includeCacheType(CacheType cacheType) {
        this.includeCaches.add(cacheType);
        return this;
    }

    public CommonStatsFlags includeAllCacheTypes() {
        this.includeCaches = EnumSet.allOf(CacheType.class);
        return this;
    }

    public CommonStatsFlags setLevels(String[] inputLevels) {
        this.levels = inputLevels;
        return this;
    }

    public boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public boolean includeAllShardIndexingPressureTrackers() {
        return this.includeAllShardIndexingPressureTrackers;
    }

    public boolean includeOnlyTopIndexingPressureMetrics() {
        return this.includeOnlyTopIndexingPressureMetrics;
    }

    public boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    public void setIncludeIndicesStatsByLevel(boolean includeIndicesStatsByLevel) {
        this.includeIndicesStatsByLevel = includeIndicesStatsByLevel;
    }

    public boolean getIncludeIndicesStatsByLevel() {
        return this.includeIndicesStatsByLevel;
    }

    public boolean isSet(Flag flag) {
        return this.flags.contains((Object)flag);
    }

    boolean unSet(Flag flag) {
        return this.flags.remove((Object)flag);
    }

    void set(Flag flag) {
        this.flags.add(flag);
    }

    public CommonStatsFlags set(Flag flag, boolean add) {
        if (add) {
            this.set(flag);
        } else {
            this.unSet(flag);
        }
        return this;
    }

    public CommonStatsFlags clone() {
        try {
            CommonStatsFlags cloned = (CommonStatsFlags)super.clone();
            cloned.flags = this.flags.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @PublicApi(since="1.0.0")
    public static enum Flag {
        Store("store", 0),
        Indexing("indexing", 1),
        Get("get", 2),
        Search("search", 3),
        Merge("merge", 4),
        Flush("flush", 5),
        Refresh("refresh", 6),
        QueryCache("query_cache", 7),
        FieldData("fielddata", 8),
        Docs("docs", 9),
        Warmer("warmer", 10),
        Completion("completion", 11),
        Segments("segments", 12),
        Translog("translog", 13),
        RequestCache("request_cache", 15),
        Recovery("recovery", 16);

        private final String restName;
        private final int index;

        private Flag(String restName, int index) {
            this.restName = restName;
            this.index = index;
        }

        public String getRestName() {
            return this.restName;
        }

        private int getIndex() {
            return this.index;
        }
    }
}

