/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public class GetIndexTemplatesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<IndexTemplateMetadata> indexTemplates;

    public GetIndexTemplatesResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.indexTemplates = new ArrayList<IndexTemplateMetadata>();
        for (int i = 0; i < size; ++i) {
            this.indexTemplates.add(IndexTemplateMetadata.readFrom(in));
        }
    }

    public GetIndexTemplatesResponse(List<IndexTemplateMetadata> indexTemplates) {
        this.indexTemplates = indexTemplates;
    }

    public List<IndexTemplateMetadata> getIndexTemplates() {
        return this.indexTemplates;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.indexTemplates.size());
        for (IndexTemplateMetadata indexTemplate : this.indexTemplates) {
            indexTemplate.writeTo(out);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexTemplatesResponse that = (GetIndexTemplatesResponse)o;
        return Objects.equals(this.indexTemplates, that.indexTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.indexTemplates);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        params = new ToXContent.DelegatingMapParams(Collections.singletonMap("reduce_mappings", "true"), params);
        builder.startObject();
        for (IndexTemplateMetadata indexTemplateMetadata : this.getIndexTemplates()) {
            IndexTemplateMetadata.Builder.toXContent(indexTemplateMetadata, builder, params);
        }
        builder.endObject();
        return builder;
    }
}

