/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.MediaTypeRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

@ExperimentalApi
public class HotToWarmTieringResponse
extends AcknowledgedResponse {
    private final List<IndexResult> failedIndices;

    public HotToWarmTieringResponse(boolean acknowledged) {
        super(acknowledged);
        this.failedIndices = Collections.emptyList();
    }

    public HotToWarmTieringResponse(boolean acknowledged, List<IndexResult> indicesResults) {
        super(acknowledged);
        this.failedIndices = indicesResults == null ? Collections.emptyList() : indicesResults.stream().sorted(Comparator.comparing(IndexResult::getIndex)).collect(Collectors.toList());
    }

    public HotToWarmTieringResponse(StreamInput in) throws IOException {
        super(in);
        this.failedIndices = Collections.unmodifiableList(in.readList(IndexResult::new));
    }

    public List<IndexResult> getFailedIndices() {
        return this.failedIndices;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeList(this.failedIndices);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        super.addCustomFields(builder, params);
        builder.startArray("failed_indices");
        for (IndexResult failedIndex : this.failedIndices) {
            failedIndex.toXContent(builder, params);
        }
        builder.endArray();
    }

    public String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this);
    }

    @ExperimentalApi
    public static class IndexResult
    implements Writeable,
    ToXContentFragment {
        private final String index;
        private final String failureReason;

        public IndexResult(String index, String failureReason) {
            this.index = index;
            this.failureReason = failureReason;
        }

        IndexResult(StreamInput in) throws IOException {
            this.index = in.readString();
            this.failureReason = in.readString();
        }

        public String getIndex() {
            return this.index;
        }

        public String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeString(this.failureReason);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("index", this.index);
            builder.field("error", this.failureReason);
            return builder.endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexResult that = (IndexResult)o;
            return Objects.equals(this.index, that.index) && Objects.equals(this.failureReason, that.failureReason);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.index);
            result = 31 * result + Objects.hashCode(this.failureReason);
            return result;
        }

        public String toString() {
            return Strings.toString(MediaTypeRegistry.JSON, this);
        }
    }
}

