/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering.HotToWarmTieringResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;

@ExperimentalApi
public class TieringValidationResult {
    private final Set<Index> acceptedIndices = ConcurrentHashMap.newKeySet();
    private final Map<Index, String> rejectedIndices;

    public TieringValidationResult(Set<Index> concreteIndices) {
        this.acceptedIndices.addAll(concreteIndices);
        this.rejectedIndices = new HashMap<Index, String>();
    }

    public Set<Index> getAcceptedIndices() {
        return this.acceptedIndices;
    }

    public Map<Index, String> getRejectedIndices() {
        return this.rejectedIndices;
    }

    public void addToRejected(Index index, String reason) {
        this.acceptedIndices.remove(index);
        this.rejectedIndices.put(index, reason);
    }

    public HotToWarmTieringResponse constructResponse() {
        LinkedList<HotToWarmTieringResponse.IndexResult> indicesResult = new LinkedList<HotToWarmTieringResponse.IndexResult>();
        for (Map.Entry<Index, String> rejectedIndex : this.rejectedIndices.entrySet()) {
            indicesResult.add(new HotToWarmTieringResponse.IndexResult(rejectedIndex.getKey().getName(), rejectedIndex.getValue()));
        }
        return new HotToWarmTieringResponse(this.acceptedIndices.size() > 0, indicesResult);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TieringValidationResult that = (TieringValidationResult)o;
        if (!Objects.equals(this.acceptedIndices, that.acceptedIndices)) {
            return false;
        }
        return Objects.equals(this.rejectedIndices, that.rejectedIndices);
    }

    public int hashCode() {
        int result = this.acceptedIndices != null ? this.acceptedIndices.hashCode() : 0;
        result = 31 * result + (this.rejectedIndices != null ? this.rejectedIndices.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TieringValidationResult{acceptedIndices=" + String.valueOf(this.acceptedIndices) + ", rejectedIndices=" + String.valueOf(this.rejectedIndices) + "}";
    }
}

