/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering;

import java.io.IOException;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering.HotToWarmTieringResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering.TieringIndexRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.tiering.TieringValidationResult;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterInfoService;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockLevel;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.DiskThresholdSettings;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;
import org.graylog.shaded.opensearch2.org.opensearch.indices.tiering.TieringRequestValidator;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

@ExperimentalApi
public class TransportHotToWarmTieringAction
extends TransportClusterManagerNodeAction<TieringIndexRequest, HotToWarmTieringResponse> {
    private static final Logger logger = LogManager.getLogger(TransportHotToWarmTieringAction.class);
    private final ClusterInfoService clusterInfoService;
    private final DiskThresholdSettings diskThresholdSettings;

    @Inject
    public TransportHotToWarmTieringAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterInfoService clusterInfoService, Settings settings) {
        super("indices:admin/tier/hot_to_warm", transportService, clusterService, threadPool, actionFilters, TieringIndexRequest::new, indexNameExpressionResolver);
        this.clusterInfoService = clusterInfoService;
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterService.getClusterSettings());
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected HotToWarmTieringResponse read(StreamInput in) throws IOException {
        return new HotToWarmTieringResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(TieringIndexRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    @Override
    protected void clusterManagerOperation(TieringIndexRequest request, ClusterState state, ActionListener<HotToWarmTieringResponse> listener) throws Exception {
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request);
        if (concreteIndices == null || concreteIndices.length == 0) {
            listener.onResponse(new HotToWarmTieringResponse(true));
            return;
        }
        TieringValidationResult tieringValidationResult = TieringRequestValidator.validateHotToWarm(state, Set.of(concreteIndices), this.clusterInfoService.getClusterInfo(), this.diskThresholdSettings);
        if (tieringValidationResult.getAcceptedIndices().isEmpty()) {
            listener.onResponse(tieringValidationResult.constructResponse());
            return;
        }
    }
}

