/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.ingest;

import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionType;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterChangedEvent;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterStateApplier;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.Randomness;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public final class IngestActionForwarder
implements ClusterStateApplier {
    private final TransportService transportService;
    private final AtomicInteger ingestNodeGenerator = new AtomicInteger(Randomness.get().nextInt());
    private DiscoveryNode[] ingestNodes;

    public IngestActionForwarder(TransportService transportService) {
        this.transportService = transportService;
        this.ingestNodes = new DiscoveryNode[0];
    }

    public void forwardIngestRequest(ActionType<?> action, ActionRequest request, ActionListener<?> listener) {
        this.transportService.sendRequest(this.randomIngestNode(), action.name(), request, new ActionListenerResponseHandler(listener, action.getResponseReader()));
    }

    private DiscoveryNode randomIngestNode() {
        DiscoveryNode[] nodes = this.ingestNodes;
        if (nodes.length == 0) {
            throw new IllegalStateException("There are no ingest nodes in this cluster, unable to forward request to an ingest node.");
        }
        return nodes[Math.floorMod(this.ingestNodeGenerator.incrementAndGet(), nodes.length)];
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        this.ingestNodes = event.state().getNodes().getIngestNodes().values().toArray(new DiscoveryNode[0]);
    }
}

