/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.pagination;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.action.pagination.PageToken;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;

public interface PaginationStrategy<T> {
    public static final String INCORRECT_TAINTED_NEXT_TOKEN_ERROR_MESSAGE = "Parameter [next_token] has been tainted and is incorrect. Please provide a valid [next_token].";

    public PageToken getResponseToken();

    public List<T> getRequestedEntities();

    public static List<IndexMetadata> getSortedIndexMetadata(ClusterState clusterState, Predicate<IndexMetadata> filterPredicate, Comparator<IndexMetadata> comparator) {
        return clusterState.metadata().indices().values().stream().filter(filterPredicate).sorted(comparator).collect(Collectors.toList());
    }

    public static List<IndexMetadata> getSortedIndexMetadata(ClusterState clusterState, Comparator<IndexMetadata> comparator) {
        return clusterState.metadata().indices().values().stream().sorted(comparator).collect(Collectors.toList());
    }

    public static String encryptStringToken(String tokenString) {
        if (Objects.isNull(tokenString)) {
            return null;
        }
        return Base64.getEncoder().encodeToString(tokenString.getBytes(StandardCharsets.UTF_8));
    }

    public static String decryptStringToken(String encTokenString) {
        if (Objects.isNull(encTokenString)) {
            return null;
        }
        try {
            return new String(Base64.getDecoder().decode(encTokenString), StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException exception) {
            throw new OpenSearchParseException(INCORRECT_TAINTED_NEXT_TOKEN_ERROR_MESSAGE, new Object[0]);
        }
    }
}

