/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.term;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.ActionFilters;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.term.GetTermVersionRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.clustermanager.term.GetTermVersionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.block.ClusterBlockException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.ClusterStateTermVersion;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.coordination.Coordinator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.ClusterService;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.FeatureFlags;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.discovery.Discovery;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportService;

public class TransportGetTermVersionAction
extends TransportClusterManagerNodeReadAction<GetTermVersionRequest, GetTermVersionResponse> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Discovery discovery;
    private boolean usePreCommitState = FeatureFlags.isEnabled(FeatureFlags.TERM_VERSION_PRECOMMIT_ENABLE_SETTING);

    @Inject
    public TransportGetTermVersionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Discovery discovery) {
        super("internal:monitor/term", false, transportService, clusterService, threadPool, actionFilters, GetTermVersionRequest::new, indexNameExpressionResolver);
        this.discovery = discovery;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    public GetTermVersionResponse read(StreamInput in) throws IOException {
        return new GetTermVersionResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(GetTermVersionRequest request, ClusterState state) {
        return null;
    }

    @Override
    protected void clusterManagerOperation(GetTermVersionRequest request, ClusterState state, ActionListener<GetTermVersionResponse> listener) throws Exception {
        if (this.usePreCommitState) {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, this.clusterService.preCommitState()));
        } else {
            ActionListener.completeWith(listener, () -> this.buildResponse(request, state));
        }
    }

    private GetTermVersionResponse buildResponse(GetTermVersionRequest request, ClusterState state) {
        Coordinator coordinator;
        ClusterStateTermVersion termVersion = new ClusterStateTermVersion(state);
        if (this.discovery instanceof Coordinator && (coordinator = (Coordinator)this.discovery).isRemotePublicationEnabled()) {
            return new GetTermVersionResponse(termVersion, coordinator.isRemotePublicationEnabled());
        }
        return new GetTermVersionResponse(termVersion);
    }
}

