/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.support.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.ExceptionsHelper;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParserUtils;

@PublicApi(since="1.0.0")
public class ReplicationResponse
extends ActionResponse {
    public static final ShardInfo.Failure[] EMPTY = new ShardInfo.Failure[0];
    private ShardInfo shardInfo;

    public ReplicationResponse() {
    }

    public ReplicationResponse(StreamInput in) throws IOException {
        super(in);
        this.shardInfo = new ShardInfo(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardInfo.writeTo(out);
    }

    public ShardInfo getShardInfo() {
        return this.shardInfo;
    }

    public void setShardInfo(ShardInfo shardInfo) {
        this.shardInfo = shardInfo;
    }

    @PublicApi(since="1.0.0")
    public static class ShardInfo
    implements Writeable,
    ToXContentObject {
        private static final String TOTAL = "total";
        private static final String SUCCESSFUL = "successful";
        private static final String FAILED = "failed";
        private static final String FAILURES = "failures";
        private int total;
        private int successful;
        private Failure[] failures = EMPTY;

        public ShardInfo() {
        }

        public ShardInfo(StreamInput in) throws IOException {
            this.total = in.readVInt();
            this.successful = in.readVInt();
            int size = in.readVInt();
            if (size > 0) {
                this.failures = new Failure[size];
                for (int i = 0; i < size; ++i) {
                    this.failures[i] = new Failure(in);
                }
            }
        }

        public ShardInfo(int total, int successful, Failure ... failures) {
            assert (total >= 0 && successful >= 0);
            this.total = total;
            this.successful = successful;
            this.failures = failures;
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public int getFailed() {
            return this.failures.length;
        }

        public Failure[] getFailures() {
            return this.failures;
        }

        public RestStatus status() {
            RestStatus status = RestStatus.OK;
            for (Failure failure : this.failures) {
                if (!failure.primary() || failure.status().getStatus() <= status.getStatus()) continue;
                status = failure.status();
            }
            return status;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.total);
            out.writeVInt(this.successful);
            out.writeVInt(this.failures.length);
            for (Failure failure : this.failures) {
                failure.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TOTAL, this.total);
            builder.field(SUCCESSFUL, this.successful);
            builder.field(FAILED, this.getFailed());
            if (this.failures.length > 0) {
                builder.startArray(FAILURES);
                for (Failure failure : this.failures) {
                    failure.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            return builder;
        }

        public static ShardInfo fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            int total = 0;
            int successful = 0;
            ArrayList<Failure> failuresList = null;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (TOTAL.equals(currentFieldName)) {
                        total = parser.intValue();
                        continue;
                    }
                    if (SUCCESSFUL.equals(currentFieldName)) {
                        successful = parser.intValue();
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (FAILURES.equals(currentFieldName)) {
                        failuresList = new ArrayList<Failure>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            failuresList.add(Failure.fromXContent(parser));
                        }
                        continue;
                    }
                    parser.skipChildren();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                parser.skipChildren();
            }
            Failure[] failures = EMPTY;
            if (failuresList != null) {
                failures = failuresList.toArray(new Failure[0]);
            }
            return new ShardInfo(total, successful, failures);
        }

        public String toString() {
            return "ShardInfo{total=" + this.total + ", successful=" + this.successful + ", failures=" + Arrays.toString(this.failures) + "}";
        }

        @PublicApi(since="1.0.0")
        public static class Failure
        extends ShardOperationFailedException
        implements ToXContentObject {
            private static final String _INDEX = "_index";
            private static final String _SHARD = "_shard";
            private static final String _NODE = "_node";
            private static final String REASON = "reason";
            private static final String STATUS = "status";
            private static final String PRIMARY = "primary";
            private final ShardId shardId;
            private final String nodeId;
            private final boolean primary;

            public Failure(StreamInput in) throws IOException {
                this.shardId = new ShardId(in);
                ((ShardOperationFailedException)this).shardId = this.shardId.getId();
                this.index = this.shardId.getIndexName();
                this.nodeId = in.readOptionalString();
                this.cause = in.readException();
                this.status = RestStatus.readFrom(in);
                this.primary = in.readBoolean();
            }

            public Failure(ShardId shardId, @Nullable String nodeId, Exception cause, RestStatus status, boolean primary) {
                super(shardId.getIndexName(), shardId.getId(), ExceptionsHelper.detailedMessage(cause), status, cause);
                this.shardId = shardId;
                this.nodeId = nodeId;
                this.primary = primary;
            }

            public ShardId fullShardId() {
                return this.shardId;
            }

            @Nullable
            public String nodeId() {
                return this.nodeId;
            }

            public boolean primary() {
                return this.primary;
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                this.shardId.writeTo(out);
                out.writeOptionalString(this.nodeId);
                out.writeException(this.cause);
                RestStatus.writeTo(out, this.status);
                out.writeBoolean(this.primary);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(_INDEX, this.shardId.getIndexName());
                builder.field(_SHARD, this.shardId.id());
                builder.field(_NODE, this.nodeId);
                builder.field(REASON);
                builder.startObject();
                OpenSearchException.generateThrowableXContent(builder, params, this.cause);
                builder.endObject();
                builder.field(STATUS, (Object)this.status);
                builder.field(PRIMARY, this.primary);
                builder.endObject();
                return builder;
            }

            public static Failure fromXContent(XContentParser parser) throws IOException {
                XContentParser.Token token = parser.currentToken();
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
                String shardIndex = null;
                String nodeId = null;
                int shardId = -1;
                boolean primary = false;
                RestStatus status = null;
                OpenSearchException reason = null;
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (_INDEX.equals(currentFieldName)) {
                            shardIndex = parser.text();
                            continue;
                        }
                        if (_SHARD.equals(currentFieldName)) {
                            shardId = parser.intValue();
                            continue;
                        }
                        if (_NODE.equals(currentFieldName)) {
                            nodeId = parser.text();
                            continue;
                        }
                        if (STATUS.equals(currentFieldName)) {
                            status = RestStatus.valueOf(parser.text());
                            continue;
                        }
                        if (!PRIMARY.equals(currentFieldName)) continue;
                        primary = parser.booleanValue();
                        continue;
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        if (REASON.equals(currentFieldName)) {
                            reason = OpenSearchException.fromXContent(parser);
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    parser.skipChildren();
                }
                return new Failure(new ShardId(shardIndex, "_na_", shardId), nodeId, reason, status, primary);
            }
        }
    }
}

