/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.bootstrap;

import java.io.IOException;
import java.nio.file.Path;
import java.security.Permission;
import java.security.Security;
import java.util.Arrays;
import java.util.Locale;
import org.graylog.shaded.opensearch2.joptsimple.OptionSet;
import org.graylog.shaded.opensearch2.joptsimple.OptionSpec;
import org.graylog.shaded.opensearch2.joptsimple.OptionSpecBuilder;
import org.graylog.shaded.opensearch2.joptsimple.util.PathConverter;
import org.graylog.shaded.opensearch2.joptsimple.util.PathProperties;
import org.graylog.shaded.opensearch2.org.opensearch.Build;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.Bootstrap;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.BootstrapException;
import org.graylog.shaded.opensearch2.org.opensearch.bootstrap.StartupException;
import org.graylog.shaded.opensearch2.org.opensearch.cli.EnvironmentAwareCommand;
import org.graylog.shaded.opensearch2.org.opensearch.cli.Terminal;
import org.graylog.shaded.opensearch2.org.opensearch.cli.UserException;
import org.graylog.shaded.opensearch2.org.opensearch.common.logging.LogConfigurator;
import org.graylog.shaded.opensearch2.org.opensearch.env.Environment;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.jvm.JvmInfo;
import org.graylog.shaded.opensearch2.org.opensearch.node.NodeValidationException;

class OpenSearch
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;
    private final OptionSpecBuilder daemonizeOption;
    private final OptionSpec<Path> pidfileOption;
    private final OptionSpecBuilder quietOption;

    OpenSearch() {
        super("Starts OpenSearch", () -> {});
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints OpenSearch version information and exits");
        this.daemonizeOption = this.parser.acceptsAll(Arrays.asList("d", "daemonize"), "Starts OpenSearch in the background").availableUnless(this.versionOption, new OptionSpec[0]);
        this.pidfileOption = this.parser.acceptsAll(Arrays.asList("p", "pidfile"), "Creates a pid file in the specified path on start").availableUnless(this.versionOption, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy(new PathConverter(new PathProperties[0]));
        this.quietOption = this.parser.acceptsAll(Arrays.asList("q", "quiet"), "Turns off standard output/error streams logging in console").availableUnless(this.versionOption, new OptionSpec[0]).availableUnless(this.daemonizeOption, new OptionSpec[0]);
    }

    public static void main(String[] args) throws Exception {
        OpenSearch.overrideDnsCachePolicyProperties();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        LogConfigurator.registerErrorListener();
        OpenSearch opensearch = new OpenSearch();
        int status = OpenSearch.main(args, opensearch, Terminal.DEFAULT);
        if (status != 0) {
            String basePath = System.getProperty("opensearch.logs.base_path");
            if (basePath != null) {
                Terminal.DEFAULT.errorPrintln("ERROR: OpenSearch did not exit normally - check the logs at " + basePath + System.getProperty("file.separator") + System.getProperty("opensearch.logs.cluster_name") + ".log");
            }
            OpenSearch.exit(status);
        }
    }

    private static void overrideDnsCachePolicyProperties() {
        for (String property : new String[]{"networkaddress.cache.ttl", "networkaddress.cache.negative.ttl"}) {
            String overrideProperty = "opensearch." + property;
            String overrideValue = System.getProperty(overrideProperty);
            if (overrideValue == null) continue;
            try {
                Security.setProperty(property, Integer.toString(Integer.valueOf(overrideValue)));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("failed to parse [" + overrideProperty + "] with value [" + overrideValue + "]", e);
            }
        }
    }

    static int main(String[] args, OpenSearch opensearch, Terminal terminal) throws Exception {
        return opensearch.main(args, terminal);
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws UserException {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + String.valueOf(options.nonOptionArguments()));
        }
        if (options.has(this.versionOption)) {
            String versionOutput = String.format(Locale.ROOT, "Version: %s, Build: %s/%s/%s, JVM: %s", Build.CURRENT.getQualifiedVersion(), Build.CURRENT.type().displayName(), Build.CURRENT.hash(), Build.CURRENT.date(), JvmInfo.jvmInfo().version());
            terminal.println(versionOutput);
            return;
        }
        boolean daemonize = options.has(this.daemonizeOption);
        Path pidFile = this.pidfileOption.value(options);
        boolean quiet = options.has(this.quietOption);
        try {
            env.validateTmpFile();
        }
        catch (IOException e) {
            throw new UserException(78, e.getMessage());
        }
        try {
            this.init(daemonize, pidFile, quiet, env);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    void init(boolean daemonize, Path pidFile, boolean quiet, Environment initialEnv) throws NodeValidationException, UserException {
        try {
            Bootstrap.init(!daemonize, pidFile, quiet, initialEnv);
        }
        catch (RuntimeException | BootstrapException e) {
            throw new StartupException(e);
        }
    }

    static void close(String[] args) throws IOException {
        Bootstrap.stop();
    }
}

