/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.graylog.shaded.opensearch2.org.apache.http.util.Args;
import org.graylog.shaded.opensearch2.org.reactivestreams.Publisher;
import org.graylog.shaded.opensearch2.org.reactivestreams.Subscriber;
import org.graylog.shaded.opensearch2.org.reactivestreams.Subscription;

class ReactiveDataConsumer
implements Publisher<ByteBuffer> {
    private final AtomicLong requests = new AtomicLong(0L);
    private final BlockingQueue<ByteBuffer> buffers = new LinkedBlockingQueue<ByteBuffer>();
    private final AtomicBoolean flushInProgress = new AtomicBoolean(false);
    private final AtomicInteger windowScalingIncrement = new AtomicInteger(0);
    private volatile boolean completed;
    private volatile Exception exception;
    private volatile Subscriber<? super ByteBuffer> subscriber;
    private final ReentrantLock lock = new ReentrantLock();

    ReactiveDataConsumer() {
    }

    public void failed(Exception cause) {
        if (!this.completed) {
            this.exception = cause;
            this.flushToSubscriber();
        }
    }

    public void consume(ByteBuffer byteBuffer) throws IOException {
        if (this.completed) {
            throw new IllegalStateException("Received data past end of stream");
        }
        byte[] copy = new byte[byteBuffer.remaining()];
        byteBuffer.get(copy);
        this.buffers.add(ByteBuffer.wrap(copy));
        this.flushToSubscriber();
    }

    public void complete() {
        this.completed = true;
        this.flushToSubscriber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushToSubscriber() {
        this.lock.lock();
        try {
            Subscriber<? super ByteBuffer> s = this.subscriber;
            if (this.flushInProgress.getAndSet(true)) {
                return;
            }
            try {
                ByteBuffer next;
                if (s == null) {
                    return;
                }
                if (this.exception != null) {
                    this.subscriber = null;
                    s.onError(this.exception);
                    return;
                }
                while (this.requests.get() > 0L && (next = (ByteBuffer)this.buffers.poll()) != null) {
                    int bytesFreed = next.remaining();
                    s.onNext(next);
                    this.requests.decrementAndGet();
                    this.windowScalingIncrement.addAndGet(bytesFreed);
                }
                if (this.completed && this.buffers.isEmpty()) {
                    this.subscriber = null;
                    s.onComplete();
                }
            }
            finally {
                this.flushInProgress.set(false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.subscriber = Args.notNull(subscriber, "subscriber");
        subscriber.onSubscribe(new Subscription(){

            @Override
            public void request(long increment) {
                if (increment <= 0L) {
                    ReactiveDataConsumer.this.failed(new IllegalArgumentException("The number of elements requested must be strictly positive"));
                    return;
                }
                ReactiveDataConsumer.this.requests.addAndGet(increment);
                ReactiveDataConsumer.this.flushToSubscriber();
            }

            @Override
            public void cancel() {
                ReactiveDataConsumer.this.subscriber = null;
            }
        });
    }
}

