/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.client;

import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.http.Header;
import org.graylog.shaded.opensearch2.org.apache.http.HttpEntity;
import org.graylog.shaded.opensearch2.org.apache.http.HttpHost;
import org.graylog.shaded.opensearch2.org.apache.http.HttpResponse;
import org.graylog.shaded.opensearch2.org.apache.http.RequestLine;
import org.graylog.shaded.opensearch2.org.apache.http.StatusLine;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseWarningsExtractor;

public class Response {
    private final RequestLine requestLine;
    private final HttpHost host;
    private final HttpResponse response;

    Response(RequestLine requestLine, HttpHost host, HttpResponse response) {
        Objects.requireNonNull(requestLine, "requestLine cannot be null");
        Objects.requireNonNull(host, "host cannot be null");
        Objects.requireNonNull(response, "response cannot be null");
        this.requestLine = requestLine;
        this.host = host;
        this.response = response;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public Header[] getHeaders() {
        return this.response.getAllHeaders();
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public HttpEntity getEntity() {
        return this.response.getEntity();
    }

    public List<String> getWarnings() {
        return ResponseWarningsExtractor.getWarnings(this.response);
    }

    public boolean hasWarnings() {
        Header[] warnings = this.response.getHeaders("Warning");
        return warnings != null && warnings.length > 0;
    }

    HttpResponse getHttpResponse() {
        return this.response;
    }

    public String toString() {
        return "Response{requestLine=" + this.requestLine + ", host=" + this.host + ", response=" + this.response.getStatusLine() + '}';
    }
}

