/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.applicationtemplates;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;

@ExperimentalApi
public class SystemTemplateMetadata {
    private final long version;
    private final String type;
    private final String name;
    private static final String DELIMITER = "@";
    public static final String COMPONENT_TEMPLATE_TYPE = "@abc_template";

    public SystemTemplateMetadata(long version, String type, String name) {
        this.version = version;
        this.type = type;
        this.name = name;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public long version() {
        return this.version;
    }

    public static SystemTemplateMetadata fromComponentTemplate(String fullyQualifiedName) {
        assert (fullyQualifiedName.length() > DELIMITER.length() * 3 + 2 + COMPONENT_TEMPLATE_TYPE.length()) : "System template name must have all defined components";
        assert ((DELIMITER + fullyQualifiedName.substring(1, fullyQualifiedName.indexOf(DELIMITER, 1))).equals(COMPONENT_TEMPLATE_TYPE));
        return new SystemTemplateMetadata(Long.parseLong(fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(DELIMITER) + 1)), COMPONENT_TEMPLATE_TYPE, fullyQualifiedName.substring(fullyQualifiedName.indexOf(DELIMITER, 2) + 1, fullyQualifiedName.lastIndexOf(DELIMITER)));
    }

    public static SystemTemplateMetadata fromComponentTemplateInfo(String name, long version) {
        return new SystemTemplateMetadata(version, COMPONENT_TEMPLATE_TYPE, name);
    }

    public final String fullyQualifiedName() {
        return this.type + DELIMITER + this.name + DELIMITER + this.version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemTemplateMetadata that = (SystemTemplateMetadata)o;
        return this.version == that.version && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.type, this.name);
    }

    public String toString() {
        return "SystemTemplateMetadata{version=" + this.version + ", type='" + this.type + "', name='" + this.name + "'}";
    }
}

