/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.Diff;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.DiffableUtils;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingTable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.StringKeyDiffProvider;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.Index;

public class RoutingTableIncrementalDiff
implements Diff<RoutingTable>,
StringKeyDiffProvider<IndexRoutingTable> {
    private final Diff<Map<String, IndexRoutingTable>> indicesRouting;
    private final long version;
    private static final DiffableUtils.DiffableValueSerializer<String, IndexRoutingTable> CUSTOM_ROUTING_TABLE_DIFFABLE_VALUE_SERIALIZER = new DiffableUtils.DiffableValueSerializer<String, IndexRoutingTable>(){

        @Override
        public IndexRoutingTable read(StreamInput in, String key) throws IOException {
            return IndexRoutingTable.readFrom(in);
        }

        @Override
        public Diff<IndexRoutingTable> readDiff(StreamInput in, String key) throws IOException {
            return new IndexRoutingTableIncrementalDiff(in);
        }

        @Override
        public Diff<IndexRoutingTable> diff(IndexRoutingTable currentState, IndexRoutingTable previousState) {
            return new IndexRoutingTableIncrementalDiff(currentState.getIndex(), previousState, currentState);
        }
    };

    public RoutingTableIncrementalDiff(RoutingTable before, RoutingTable after) {
        this.version = after.version();
        this.indicesRouting = DiffableUtils.diff(before.getIndicesRouting(), after.getIndicesRouting(), DiffableUtils.getStringKeySerializer(), CUSTOM_ROUTING_TABLE_DIFFABLE_VALUE_SERIALIZER);
    }

    public RoutingTableIncrementalDiff(StreamInput in) throws IOException {
        this.version = in.readLong();
        this.indicesRouting = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_ROUTING_TABLE_DIFFABLE_VALUE_SERIALIZER);
    }

    public static RoutingTableIncrementalDiff readFrom(StreamInput in) throws IOException {
        return new RoutingTableIncrementalDiff(in);
    }

    @Override
    public RoutingTable apply(RoutingTable part) {
        return new RoutingTable(this.version, this.indicesRouting.apply(part.getIndicesRouting()));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        this.indicesRouting.writeTo(out);
    }

    @Override
    public DiffableUtils.MapDiff<String, IndexRoutingTable, Map<String, IndexRoutingTable>> provideDiff() {
        return (DiffableUtils.MapDiff)this.indicesRouting;
    }

    public static class IndexRoutingTableIncrementalDiff
    implements Diff<IndexRoutingTable> {
        private final Diff<Map<Integer, IndexShardRoutingTable>> indexShardRoutingTables;
        private final Index index;
        private static final DiffableUtils.DiffableValueReader<Integer, IndexShardRoutingTable> DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexShardRoutingTable::readFrom, IndexShardRoutingTable::readDiffFrom);

        public IndexRoutingTableIncrementalDiff(Index index, IndexRoutingTable before, IndexRoutingTable after) {
            this.index = index;
            this.indexShardRoutingTables = DiffableUtils.diff(before.getShards(), after.getShards(), DiffableUtils.getIntKeySerializer());
        }

        public IndexRoutingTableIncrementalDiff(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.indexShardRoutingTables = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getIntKeySerializer(), DIFF_VALUE_READER);
        }

        @Override
        public IndexRoutingTable apply(IndexRoutingTable part) {
            return new IndexRoutingTable(this.index, this.indexShardRoutingTables.apply(part.getShards()));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            this.indexShardRoutingTables.writeTo(out);
        }

        public static IndexRoutingTableIncrementalDiff readFrom(StreamInput in) throws IOException {
            return new IndexRoutingTableIncrementalDiff(in);
        }
    }
}

