/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNodes;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RerouteExplanation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.command.AbstractAllocateAllocationCommand;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexNotFoundException;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.ShardNotFoundException;

public class AllocateReplicaAllocationCommand
extends AbstractAllocateAllocationCommand {
    public static final String NAME = "allocate_replica";
    public static final ParseField COMMAND_NAME_FIELD = new ParseField("allocate_replica", new String[0]);
    private static final ObjectParser<Builder, Void> REPLICA_PARSER = AllocateReplicaAllocationCommand.createAllocateParser("allocate_replica");

    public AllocateReplicaAllocationCommand(String index, int shardId, String node) {
        super(index, shardId, node);
    }

    public AllocateReplicaAllocationCommand(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public String name() {
        return NAME;
    }

    public static AllocateReplicaAllocationCommand fromXContent(XContentParser parser) throws IOException {
        return new Builder().parse(parser).build();
    }

    @Override
    public RerouteExplanation execute(RoutingAllocation allocation, boolean explain) {
        DiscoveryNode discoNode;
        try {
            discoNode = allocation.nodes().resolveNode(this.node);
        }
        catch (IllegalArgumentException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNode routingNode = routingNodes.node(discoNode.getId());
        if (routingNode == null) {
            return this.explainOrThrowMissingRoutingNode(allocation, explain, discoNode);
        }
        try {
            allocation.routingTable().shardRoutingTable(this.index, this.shardId).primaryShard();
        }
        catch (IndexNotFoundException | ShardNotFoundException e) {
            return this.explainOrThrowRejectedCommand(explain, allocation, e);
        }
        ShardRouting primaryShardRouting = null;
        block4: for (Object node : allocation.routingNodes()) {
            Iterator<ShardRouting> iterator = ((RoutingNode)node).iterator();
            while (iterator.hasNext()) {
                ShardRouting shard = iterator.next();
                if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || !shard.primary()) continue;
                primaryShardRouting = shard;
                continue block4;
            }
        }
        if (primaryShardRouting == null) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "trying to allocate a replica shard [" + this.index + "][" + this.shardId + "], while corresponding primary shard is still unassigned");
        }
        ArrayList<ShardRouting> replicaShardRoutings = new ArrayList<ShardRouting>();
        for (ShardRouting shard : allocation.routingNodes().unassigned()) {
            if (!shard.getIndexName().equals(this.index) || shard.getId() != this.shardId || shard.primary()) continue;
            replicaShardRoutings.add(shard);
        }
        if (replicaShardRoutings.isEmpty()) {
            return this.explainOrThrowRejectedCommand(explain, allocation, "all copies of [" + this.index + "][" + this.shardId + "] are already assigned. Use the move allocation command instead");
        }
        ShardRouting shardRouting = (ShardRouting)replicaShardRoutings.get(0);
        Decision decision = allocation.deciders().canAllocate(shardRouting, routingNode, allocation);
        if (decision.type() == Decision.Type.NO) {
            if (explain) {
                return new RerouteExplanation(this, decision);
            }
            throw new IllegalArgumentException("[" + this.name() + "] allocation of [" + this.index + "][" + this.shardId + "] on node " + String.valueOf(discoNode) + " is not allowed, reason: " + String.valueOf(decision));
        }
        this.initializeUnassignedShard(allocation, routingNodes, routingNode, shardRouting);
        return new RerouteExplanation(this, decision);
    }

    protected static class Builder
    extends AbstractAllocateAllocationCommand.Builder<AllocateReplicaAllocationCommand> {
        protected Builder() {
        }

        public Builder parse(XContentParser parser) throws IOException {
            return REPLICA_PARSER.parse(parser, this, null);
        }

        @Override
        public AllocateReplicaAllocationCommand build() {
            this.validate();
            return new AllocateReplicaAllocationCommand(this.index, this.shard, this.node);
        }
    }
}

