/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider;

import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.RoutingNode;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.RoutingAllocation;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.AllocationDecider;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.allocation.decider.Decision;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.core.index.shard.ShardId;
import org.graylog.shaded.opensearch2.org.opensearch.node.remotestore.RemoteStoreNodeService;

public class RemoteStoreMigrationAllocationDecider
extends AllocationDecider {
    public static final String NAME = "remote_store_migration";
    private volatile RemoteStoreNodeService.Direction migrationDirection;
    private volatile RemoteStoreNodeService.CompatibilityMode compatibilityMode;

    public RemoteStoreMigrationAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        this.migrationDirection = RemoteStoreNodeService.MIGRATION_DIRECTION_SETTING.get(settings);
        this.compatibilityMode = RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(RemoteStoreNodeService.MIGRATION_DIRECTION_SETTING, this::setMigrationDirection);
        clusterSettings.addSettingsUpdateConsumer(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING, this::setCompatibilityMode);
    }

    private void setMigrationDirection(RemoteStoreNodeService.Direction migrationDirection) {
        this.migrationDirection = migrationDirection;
    }

    private void setCompatibilityMode(RemoteStoreNodeService.CompatibilityMode compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        DiscoveryNode targetNode = node.node();
        if (this.compatibilityMode.equals((Object)RemoteStoreNodeService.CompatibilityMode.STRICT)) {
            return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, shardRouting, targetNode, " for strict compatibility mode", allocation), new Object[0]);
        }
        IndexMetadata indexMetadata = allocation.metadata().getIndexSafe(shardRouting.index());
        boolean remoteSettingsBackedIndex = IndexMetadata.INDEX_REMOTE_STORE_ENABLED_SETTING.get(indexMetadata.getSettings());
        if (this.migrationDirection.equals((Object)RemoteStoreNodeService.Direction.NONE)) {
            boolean isNoDecision = remoteSettingsBackedIndex ^ targetNode.isRemoteStoreNode();
            String reason = " for " + (remoteSettingsBackedIndex ? "" : "non ") + "remote store backed index";
            return allocation.decision(isNoDecision ? Decision.NO : Decision.YES, NAME, this.getDecisionDetails(!isNoDecision, shardRouting, targetNode, reason, allocation), new Object[0]);
        }
        if (this.migrationDirection.equals((Object)RemoteStoreNodeService.Direction.DOCREP)) {
            return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, shardRouting, targetNode, " for DOCREP direction", allocation), new Object[0]);
        }
        if (remoteSettingsBackedIndex && !targetNode.isRemoteStoreNode()) {
            String reason = " because a remote store backed index's shard copy can only be " + (!shardRouting.assignedToNode() ? "allocated" : "relocated") + " to a remote node";
            return allocation.decision(Decision.NO, NAME, this.getDecisionDetails(false, shardRouting, targetNode, reason, allocation), new Object[0]);
        }
        if (shardRouting.primary()) {
            return this.primaryShardDecision(shardRouting, targetNode, allocation);
        }
        return this.replicaShardDecision(shardRouting, targetNode, allocation);
    }

    private Decision primaryShardDecision(ShardRouting primaryShardRouting, DiscoveryNode targetNode, RoutingAllocation allocation) {
        if (!targetNode.isRemoteStoreNode()) {
            return allocation.decision(Decision.NO, NAME, this.getDecisionDetails(false, primaryShardRouting, targetNode, "", allocation), new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, primaryShardRouting, targetNode, "", allocation), new Object[0]);
    }

    static boolean isPrimaryOnRemote(ShardId shardId, RoutingAllocation allocation) {
        ShardRouting primaryShardRouting = allocation.routingNodes().activePrimary(shardId);
        if (primaryShardRouting != null) {
            DiscoveryNode primaryShardNode = allocation.nodes().getNodes().get(primaryShardRouting.currentNodeId());
            return primaryShardNode.isRemoteStoreNode();
        }
        return false;
    }

    private Decision replicaShardDecision(ShardRouting replicaShardRouting, DiscoveryNode targetNode, RoutingAllocation allocation) {
        if (targetNode.isRemoteStoreNode()) {
            boolean primaryOnRemote = RemoteStoreMigrationAllocationDecider.isPrimaryOnRemote(replicaShardRouting.shardId(), allocation);
            if (!primaryOnRemote) {
                return allocation.decision(Decision.NO, NAME, this.getDecisionDetails(false, replicaShardRouting, targetNode, " since primary shard copy is not yet migrated to remote", allocation), new Object[0]);
            }
            return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, replicaShardRouting, targetNode, " since primary shard copy has been migrated to remote", allocation), new Object[0]);
        }
        return allocation.decision(Decision.YES, NAME, this.getDecisionDetails(true, replicaShardRouting, targetNode, "", allocation), new Object[0]);
    }

    private String getDecisionDetails(boolean isYes, ShardRouting shardRouting, DiscoveryNode targetNode, String reason, RoutingAllocation allocation) {
        if (!allocation.debugDecision()) {
            return null;
        }
        return "[" + this.migrationDirection.direction + " migration_direction]: " + (shardRouting.primary() ? "primary" : "replica") + " shard copy " + (isYes ? "can" : "can not") + " be " + (!shardRouting.assignedToNode() ? "allocated" : "relocated") + " to a " + (targetNode.isRemoteStoreNode() ? "remote" : "non-remote") + " node" + reason;
    }
}

