/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.cluster.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.SourcePrioritizedRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.service.TaskBatcherListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.Priority;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.PrioritizedOpenSearchThreadPoolExecutor;
import org.graylog.shaded.opensearch2.org.opensearch.core.concurrency.OpenSearchRejectedExecutionException;

public abstract class TaskBatcher {
    private final Logger logger;
    private final PrioritizedOpenSearchThreadPoolExecutor threadExecutor;
    final Map<Object, LinkedHashSet<BatchedTask>> tasksPerBatchingKey = new ConcurrentHashMap<Object, LinkedHashSet<BatchedTask>>();
    final Map<Object, Map<Object, BatchedTask>> taskIdentityPerBatchingKey = new ConcurrentHashMap<Object, Map<Object, BatchedTask>>();
    private final TaskBatcherListener taskBatcherListener;

    public TaskBatcher(Logger logger, PrioritizedOpenSearchThreadPoolExecutor threadExecutor, TaskBatcherListener taskBatcherListener) {
        this.logger = logger;
        this.threadExecutor = threadExecutor;
        this.taskBatcherListener = taskBatcherListener;
    }

    public void submitTasks(List<? extends BatchedTask> tasks, @Nullable TimeValue timeout) throws OpenSearchRejectedExecutionException {
        if (tasks.isEmpty()) {
            return;
        }
        BatchedTask firstTask = tasks.get(0);
        assert (tasks.stream().allMatch(t -> t.batchingKey == firstTask.batchingKey)) : "tasks submitted in a batch should share the same batching key: " + String.valueOf(tasks);
        assert (tasks.stream().allMatch(t -> t.getTask().getClass() == firstTask.getTask().getClass())) : "tasks submitted in a batch should be of same class: " + String.valueOf(tasks);
        this.taskBatcherListener.onBeginSubmit(tasks);
        try {
            Map tasksIdentity = tasks.stream().collect(Collectors.toMap(BatchedTask::getTask, Function.identity(), (a, b) -> {
                throw new IllegalStateException("cannot add duplicate task: " + String.valueOf(a));
            }, IdentityHashMap::new));
            LinkedHashSet<? extends BatchedTask> newTasks = new LinkedHashSet<BatchedTask>(tasks);
            this.taskIdentityPerBatchingKey.merge(firstTask.batchingKey, tasksIdentity, (existingIdentities, newIdentities) -> {
                for (Object newIdentity : newIdentities.keySet()) {
                    if (!existingIdentities.containsKey(newIdentity)) continue;
                    BatchedTask duplicateTask = (BatchedTask)newIdentities.get(newIdentity);
                    throw new IllegalStateException("task [" + duplicateTask.describeTasks(Collections.singletonList(duplicateTask)) + "] with source [" + duplicateTask.source + "] is already queued");
                }
                existingIdentities.putAll(newIdentities);
                return existingIdentities;
            });
            this.tasksPerBatchingKey.merge(firstTask.batchingKey, newTasks, (existingTasks, updatedTasks) -> {
                existingTasks.addAll(updatedTasks);
                return existingTasks;
            });
        }
        catch (Exception e) {
            this.taskBatcherListener.onSubmitFailure(tasks);
            throw e;
        }
        if (timeout != null) {
            this.threadExecutor.execute(firstTask, timeout, () -> this.onTimeoutInternal(tasks, timeout));
        } else {
            this.threadExecutor.execute(firstTask);
        }
    }

    void onTimeoutInternal(List<? extends BatchedTask> tasks, TimeValue timeout) {
        ArrayList<BatchedTask> toRemove = new ArrayList<BatchedTask>();
        ArrayList<Object> toRemoveIdentities = new ArrayList<Object>();
        for (BatchedTask batchedTask : tasks) {
            if (batchedTask.processed.getAndSet(true)) continue;
            this.logger.debug("task [{}] timed out after [{}]", (Object)batchedTask.source, (Object)timeout);
            toRemove.add(batchedTask);
            toRemoveIdentities.add(batchedTask.getTask());
        }
        if (!toRemove.isEmpty()) {
            BatchedTask firstTask = (BatchedTask)toRemove.get(0);
            Object object = firstTask.batchingKey;
            assert (tasks.stream().allMatch(t -> t.batchingKey == batchingKey)) : "tasks submitted in a batch should share the same batching key: " + String.valueOf(tasks);
            this.tasksPerBatchingKey.computeIfPresent(object, (tasksKey, existingTasks) -> {
                existingTasks.removeAll(toRemove);
                if (existingTasks.isEmpty()) {
                    return null;
                }
                return existingTasks;
            });
            this.taskIdentityPerBatchingKey.computeIfPresent(object, (tasksKey, existingIdentities) -> {
                toRemoveIdentities.stream().forEach(existingIdentities::remove);
                if (existingIdentities.isEmpty()) {
                    return null;
                }
                return existingIdentities;
            });
            this.taskBatcherListener.onTimeout(toRemove);
            this.onTimeout(toRemove, timeout);
        }
    }

    protected abstract void onTimeout(List<? extends BatchedTask> var1, TimeValue var2);

    void runIfNotProcessed(BatchedTask updateTask) {
        if (!updateTask.processed.get()) {
            ArrayList<BatchedTask> toExecute = new ArrayList<BatchedTask>();
            LinkedHashSet<BatchedTask> pending = this.tasksPerBatchingKey.remove(updateTask.batchingKey);
            this.taskIdentityPerBatchingKey.remove(updateTask.batchingKey);
            if (pending != null) {
                for (BatchedTask task : pending) {
                    if (!task.processed.getAndSet(true)) {
                        this.logger.trace("will process {}", (Object)task);
                        toExecute.add(task);
                        continue;
                    }
                    this.logger.trace("skipping {}, already processed", (Object)task);
                }
            }
            if (!toExecute.isEmpty()) {
                Function<Boolean, String> taskSummaryGenerator = longSummaryRequired -> {
                    if (longSummaryRequired == null || !longSummaryRequired.booleanValue()) {
                        List<BatchedTask> sampleTasks = toExecute.stream().limit(Math.min(1000, toExecute.size())).collect(Collectors.toList());
                        return this.buildShortSummary(updateTask.batchingKey, toExecute.size(), this.getSummary(updateTask, sampleTasks));
                    }
                    return this.getSummary(updateTask, toExecute);
                };
                this.taskBatcherListener.onBeginProcessing(toExecute);
                this.run(updateTask.batchingKey, toExecute, taskSummaryGenerator);
            }
        }
    }

    private String getSummary(BatchedTask updateTask, List<BatchedTask> toExecute) {
        HashMap<String, List> processTasksBySource = new HashMap<String, List>();
        for (BatchedTask task : toExecute) {
            processTasksBySource.computeIfAbsent(task.source, s -> new ArrayList()).add(task);
        }
        return processTasksBySource.entrySet().stream().map(entry -> {
            String tasks = updateTask.describeTasks((List)entry.getValue());
            return tasks.isEmpty() ? (String)entry.getKey() : (String)entry.getKey() + "[" + tasks + "]";
        }).reduce((s1, s2) -> s1 + ", " + s2).orElse("");
    }

    private String buildShortSummary(Object batchingKey, int taskCount, String sampleTasks) {
        return "Tasks batched with key: " + batchingKey.toString().split("\\$")[0] + ", count:" + taskCount + " and sample tasks: " + sampleTasks;
    }

    protected abstract void run(Object var1, List<? extends BatchedTask> var2, Function<Boolean, String> var3);

    protected abstract class BatchedTask
    extends SourcePrioritizedRunnable {
        protected final AtomicBoolean processed;
        protected final Object batchingKey;
        protected final Object task;

        protected BatchedTask(Priority priority, String source, Object batchingKey, Object task) {
            super(priority, source);
            this.processed = new AtomicBoolean();
            this.batchingKey = batchingKey;
            this.task = task;
        }

        @Override
        public void run() {
            TaskBatcher.this.runIfNotProcessed(this);
        }

        @Override
        public String toString() {
            String taskDescription = this.describeTasks(Collections.singletonList(this));
            if (taskDescription.isEmpty()) {
                return "[" + this.source + "]";
            }
            return "[" + this.source + "[" + taskDescription + "]]";
        }

        public abstract String describeTasks(List<? extends BatchedTask> var1);

        public Object getTask() {
            return this.task;
        }
    }
}

