/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.LocalTimeOffset;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.round.Roundable;
import org.graylog.shaded.opensearch2.org.opensearch.common.round.RoundableFactory;
import org.graylog.shaded.opensearch2.org.opensearch.common.time.DateUtils;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="1.0.0")
public abstract class Rounding
implements Writeable {
    private static final Logger logger = LogManager.getLogger(Rounding.class);

    public abstract void innerWriteTo(StreamOutput var1) throws IOException;

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeByte(this.id());
        this.innerWriteTo(out);
    }

    public abstract byte id();

    public DateTimeUnit unit() {
        return null;
    }

    public boolean isUTC() {
        throw new UnsupportedOperationException();
    }

    public abstract Prepared prepare(long var1, long var3);

    public abstract Prepared prepareForUnknown();

    abstract Prepared prepareJavaTime();

    @Deprecated
    public final long round(long utcMillis) {
        return this.prepare(utcMillis, utcMillis).round(utcMillis);
    }

    @Deprecated
    public final long nextRoundingValue(long utcMillis) {
        return this.prepare(utcMillis, utcMillis).nextRoundingValue(utcMillis);
    }

    @Deprecated
    public abstract long offset();

    public abstract Rounding withoutOffset();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Builder builder(DateTimeUnit unit) {
        return new Builder(unit);
    }

    public static Builder builder(TimeValue interval) {
        return new Builder(interval);
    }

    public static Rounding read(StreamInput in) throws IOException {
        byte id = in.readByte();
        switch (id) {
            case 1: {
                return new TimeUnitRounding(in);
            }
            case 2: {
                return new TimeIntervalRounding(in);
            }
            case 3: {
                return new OffsetRounding(in);
            }
        }
        throw new OpenSearchException("unknown rounding id [" + id + "]", new Object[0]);
    }

    public static OptionalLong getInterval(Rounding rounding) {
        long interval = 0L;
        if (rounding instanceof TimeUnitRounding) {
            interval = ((TimeUnitRounding)rounding).unit.extraLocalOffsetLookup();
        } else if (rounding instanceof TimeIntervalRounding) {
            interval = ((TimeIntervalRounding)rounding).interval;
        } else {
            return OptionalLong.empty();
        }
        return OptionalLong.of(interval);
    }

    @PublicApi(since="1.0.0")
    public static interface Prepared {
        public long round(long var1);

        public long nextRoundingValue(long var1);

        public double roundingSize(long var1, DateTimeUnit var3);
    }

    @PublicApi(since="1.0.0")
    public static class Builder {
        private final DateTimeUnit unit;
        private final long interval;
        private ZoneId timeZone = ZoneOffset.UTC;
        private long offset = 0L;

        public Builder(DateTimeUnit unit) {
            this.unit = unit;
            this.interval = -1L;
        }

        public Builder(TimeValue interval) {
            this.unit = null;
            if (interval.millis() < 1L) {
                throw new IllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval.millis();
        }

        public Builder timeZone(ZoneId timeZone) {
            if (timeZone == null) {
                throw new IllegalArgumentException("Setting null as timezone is not supported");
            }
            this.timeZone = timeZone;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Rounding build() {
            Rounding rounding = this.unit != null ? new TimeUnitRounding(this.unit, this.timeZone) : new TimeIntervalRounding(this.interval, this.timeZone);
            if (this.offset != 0L) {
                rounding = new OffsetRounding(rounding, this.offset);
            }
            return rounding;
        }
    }

    @PublicApi(since="1.0.0")
    public static enum DateTimeUnit {
        WEEK_OF_WEEKYEAR(1, "week", IsoFields.WEEK_OF_WEEK_BASED_YEAR, true, TimeUnit.DAYS.toMillis(7L)){
            private final long extraLocalOffsetLookup = TimeUnit.DAYS.toMillis(7L);

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundWeekOfWeekYear(utcMillis);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.extraLocalOffsetLookup;
            }
        }
        ,
        YEAR_OF_CENTURY(2, "year", ChronoField.YEAR_OF_ERA, false, 12L){
            private final long extraLocalOffsetLookup = TimeUnit.DAYS.toMillis(366L);

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundYear(utcMillis);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.extraLocalOffsetLookup;
            }
        }
        ,
        QUARTER_OF_YEAR(3, "quarter", IsoFields.QUARTER_OF_YEAR, false, 3L){
            private final long extraLocalOffsetLookup = TimeUnit.DAYS.toMillis(92L);

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundQuarterOfYear(utcMillis);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.extraLocalOffsetLookup;
            }
        }
        ,
        MONTH_OF_YEAR(4, "month", ChronoField.MONTH_OF_YEAR, false, 1L){
            private final long extraLocalOffsetLookup = TimeUnit.DAYS.toMillis(31L);

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundMonthOfYear(utcMillis);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.extraLocalOffsetLookup;
            }
        }
        ,
        DAY_OF_MONTH(5, "day", ChronoField.DAY_OF_MONTH, true, ChronoField.DAY_OF_MONTH.getBaseUnit().getDuration().toMillis()){

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundFloor(utcMillis, this.ratio);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.ratio;
            }
        }
        ,
        HOUR_OF_DAY(6, "hour", ChronoField.HOUR_OF_DAY, true, ChronoField.HOUR_OF_DAY.getBaseUnit().getDuration().toMillis()){

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundFloor(utcMillis, this.ratio);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.ratio;
            }
        }
        ,
        MINUTES_OF_HOUR(7, "minute", ChronoField.MINUTE_OF_HOUR, true, ChronoField.MINUTE_OF_HOUR.getBaseUnit().getDuration().toMillis()){

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundFloor(utcMillis, this.ratio);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.ratio;
            }
        }
        ,
        SECOND_OF_MINUTE(8, "second", ChronoField.SECOND_OF_MINUTE, true, ChronoField.SECOND_OF_MINUTE.getBaseUnit().getDuration().toMillis()){

            @Override
            public long roundFloor(long utcMillis) {
                return DateUtils.roundFloor(utcMillis, this.ratio);
            }

            @Override
            long extraLocalOffsetLookup() {
                return this.ratio;
            }
        };

        private final byte id;
        private final TemporalField field;
        private final boolean isMillisBased;
        private final String shortName;
        protected final long ratio;

        private DateTimeUnit(byte id, String shortName, TemporalField field, boolean isMillisBased, long ratio) {
            this.id = id;
            this.shortName = shortName;
            this.field = field;
            this.isMillisBased = isMillisBased;
            this.ratio = ratio;
        }

        public abstract long roundFloor(long var1);

        abstract long extraLocalOffsetLookup();

        public byte getId() {
            return this.id;
        }

        public TemporalField getField() {
            return this.field;
        }

        public static DateTimeUnit resolve(String name) {
            return DateTimeUnit.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String shortName() {
            return this.shortName;
        }

        public static DateTimeUnit resolve(byte id) {
            switch (id) {
                case 1: {
                    return WEEK_OF_WEEKYEAR;
                }
                case 2: {
                    return YEAR_OF_CENTURY;
                }
                case 3: {
                    return QUARTER_OF_YEAR;
                }
                case 4: {
                    return MONTH_OF_YEAR;
                }
                case 5: {
                    return DAY_OF_MONTH;
                }
                case 6: {
                    return HOUR_OF_DAY;
                }
                case 7: {
                    return MINUTES_OF_HOUR;
                }
                case 8: {
                    return SECOND_OF_MINUTE;
                }
            }
            throw new OpenSearchException("Unknown date time unit id [" + id + "]", new Object[0]);
        }
    }

    static class TimeUnitRounding
    extends Rounding {
        static final byte ID = 1;
        private final DateTimeUnit unit;
        private final ZoneId timeZone;
        private final boolean unitRoundsToMidnight;

        TimeUnitRounding(DateTimeUnit unit, ZoneId timeZone) {
            this.unit = unit;
            this.timeZone = timeZone;
            this.unitRoundsToMidnight = this.unit.field.getBaseUnit().getDuration().toMillis() > 3600000L;
        }

        TimeUnitRounding(StreamInput in) throws IOException {
            this(DateTimeUnit.resolve(in.readByte()), in.getVersion().onOrAfter(LegacyESVersion.V_7_0_0) ? in.readZoneId() : DateUtils.of(in.readString()));
        }

        @Override
        public void innerWriteTo(StreamOutput out) throws IOException {
            out.writeByte(this.unit.getId());
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
                out.writeZoneId(this.timeZone);
            } else {
                out.writeString(DateUtils.zoneIdToDateTimeZone(this.timeZone).getID());
            }
        }

        @Override
        public byte id() {
            return 1;
        }

        @Override
        public DateTimeUnit unit() {
            return this.unit;
        }

        private LocalDateTime truncateLocalDateTime(LocalDateTime localDateTime) {
            switch (this.unit.ordinal()) {
                case 7: {
                    return localDateTime.withNano(0);
                }
                case 6: {
                    return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), 0, 0);
                }
                case 5: {
                    return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth(), localDateTime.getDayOfMonth(), localDateTime.getHour(), 0, 0);
                }
                case 4: {
                    LocalDate localDate = localDateTime.query(TemporalQueries.localDate());
                    return localDate.atStartOfDay();
                }
                case 0: {
                    return LocalDateTime.of(localDateTime.toLocalDate(), LocalTime.MIDNIGHT).with(ChronoField.DAY_OF_WEEK, 1L);
                }
                case 3: {
                    return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonthValue(), 1, 0, 0);
                }
                case 2: {
                    return LocalDateTime.of(localDateTime.getYear(), localDateTime.getMonth().firstMonthOfQuarter(), 1, 0, 0);
                }
                case 1: {
                    return LocalDateTime.of(LocalDate.of(localDateTime.getYear(), 1, 1), LocalTime.MIDNIGHT);
                }
            }
            throw new IllegalArgumentException("NOT YET IMPLEMENTED for unit " + String.valueOf((Object)this.unit));
        }

        @Override
        public Prepared prepare(long minUtcMillis, long maxUtcMillis) {
            return this.prepareOffsetOrJavaTimeRounding(minUtcMillis, maxUtcMillis).maybeUseArray(minUtcMillis, maxUtcMillis, 128);
        }

        private TimeUnitPreparedRounding prepareOffsetOrJavaTimeRounding(long minUtcMillis, long maxUtcMillis) {
            LocalTimeOffset.Lookup lookup;
            long minLookup = minUtcMillis - this.unit.extraLocalOffsetLookup();
            long maxLookup = maxUtcMillis;
            long unitMillis = 0L;
            if (!this.unitRoundsToMidnight) {
                unitMillis = this.unit.field.getBaseUnit().getDuration().toMillis();
                maxLookup += 2L * unitMillis;
            }
            if ((lookup = LocalTimeOffset.lookup(this.timeZone, minLookup, maxLookup)) == null) {
                return this.prepareJavaTime();
            }
            LocalTimeOffset fixedOffset = lookup.fixedInRange(minLookup, maxLookup);
            if (fixedOffset != null) {
                if (this.unitRoundsToMidnight) {
                    return new FixedToMidnightRounding(fixedOffset);
                }
                return new FixedNotToMidnightRounding(fixedOffset, unitMillis);
            }
            if (this.unitRoundsToMidnight) {
                return new ToMidnightRounding(lookup);
            }
            return new NotToMidnightRounding(lookup, unitMillis);
        }

        @Override
        public Prepared prepareForUnknown() {
            LocalTimeOffset offset = LocalTimeOffset.fixedOffset(this.timeZone);
            if (offset != null) {
                if (this.unitRoundsToMidnight) {
                    return new FixedToMidnightRounding(offset);
                }
                return new FixedNotToMidnightRounding(offset, this.unit.field.getBaseUnit().getDuration().toMillis());
            }
            return this.prepareJavaTime();
        }

        @Override
        TimeUnitPreparedRounding prepareJavaTime() {
            if (this.unitRoundsToMidnight) {
                return new JavaTimeToMidnightRounding();
            }
            return new JavaTimeNotToMidnightRounding(this.unit.field.getBaseUnit().getDuration().toMillis());
        }

        @Override
        public long offset() {
            return 0L;
        }

        @Override
        public Rounding withoutOffset() {
            return this;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.unit, this.timeZone});
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeUnitRounding other = (TimeUnitRounding)obj;
            return Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals(this.timeZone, other.timeZone);
        }

        public String toString() {
            return "Rounding[" + String.valueOf((Object)this.unit) + " in " + String.valueOf(this.timeZone) + "]";
        }

        @Override
        public boolean isUTC() {
            return "Z".equals(this.timeZone.getDisplayName(TextStyle.FULL, Locale.ENGLISH));
        }

        private abstract class TimeUnitPreparedRounding
        extends PreparedRounding {
            private TimeUnitPreparedRounding() {
            }

            @Override
            public double roundingSize(long utcMillis, DateTimeUnit timeUnit) {
                if (timeUnit.isMillisBased == TimeUnitRounding.this.unit.isMillisBased) {
                    return (double)TimeUnitRounding.this.unit.ratio / (double)timeUnit.ratio;
                }
                if (!TimeUnitRounding.this.unit.isMillisBased) {
                    return (double)(this.nextRoundingValue(utcMillis) - utcMillis) / (double)timeUnit.ratio;
                }
                throw new IllegalArgumentException("Cannot use month-based rate unit [" + timeUnit.shortName + "] with non-month based calendar interval histogram [" + TimeUnitRounding.this.unit.shortName + "] only week, day, hour, minute and second are supported for this histogram");
            }
        }

        private class FixedToMidnightRounding
        extends TimeUnitPreparedRounding {
            private final LocalTimeOffset offset;

            FixedToMidnightRounding(LocalTimeOffset offset) {
                this.offset = offset;
            }

            @Override
            public long round(long utcMillis) {
                return this.offset.localToUtcInThisOffset(TimeUnitRounding.this.unit.roundFloor(this.offset.utcToLocalTime(utcMillis)));
            }

            @Override
            public long nextRoundingValue(long utcMillis) {
                return new JavaTimeToMidnightRounding().nextRoundingValue(utcMillis);
            }
        }

        private class FixedNotToMidnightRounding
        extends TimeUnitPreparedRounding {
            private final LocalTimeOffset offset;
            private final long unitMillis;

            FixedNotToMidnightRounding(LocalTimeOffset offset, long unitMillis) {
                this.offset = offset;
                this.unitMillis = unitMillis;
            }

            @Override
            public long round(long utcMillis) {
                return this.offset.localToUtcInThisOffset(TimeUnitRounding.this.unit.roundFloor(this.offset.utcToLocalTime(utcMillis)));
            }

            @Override
            public final long nextRoundingValue(long utcMillis) {
                return this.round(utcMillis + this.unitMillis);
            }
        }

        private class ToMidnightRounding
        extends TimeUnitPreparedRounding
        implements LocalTimeOffset.Strategy {
            private final LocalTimeOffset.Lookup lookup;

            ToMidnightRounding(LocalTimeOffset.Lookup lookup) {
                this.lookup = lookup;
            }

            @Override
            public long round(long utcMillis) {
                LocalTimeOffset offset = this.lookup.lookup(utcMillis);
                return offset.localToUtc(TimeUnitRounding.this.unit.roundFloor(offset.utcToLocalTime(utcMillis)), this);
            }

            @Override
            public long nextRoundingValue(long utcMillis) {
                return new JavaTimeToMidnightRounding().nextRoundingValue(utcMillis);
            }

            @Override
            public long inGap(long localMillis, LocalTimeOffset.Gap gap) {
                return gap.startUtcMillis();
            }

            @Override
            public long beforeGap(long localMillis, LocalTimeOffset.Gap gap) {
                return gap.previous().localToUtc(localMillis, this);
            }

            @Override
            public long inOverlap(long localMillis, LocalTimeOffset.Overlap overlap) {
                return overlap.previous().localToUtc(localMillis, this);
            }

            @Override
            public long beforeOverlap(long localMillis, LocalTimeOffset.Overlap overlap) {
                return overlap.previous().localToUtc(localMillis, this);
            }

            @Override
            protected Prepared maybeUseArray(long minUtcMillis, long maxUtcMillis, int max) {
                if (this.lookup.anyMoveBackToPreviousDay()) {
                    return this;
                }
                return super.maybeUseArray(minUtcMillis, maxUtcMillis, max);
            }
        }

        private class NotToMidnightRounding
        extends AbstractNotToMidnightRounding
        implements LocalTimeOffset.Strategy {
            private final LocalTimeOffset.Lookup lookup;

            NotToMidnightRounding(LocalTimeOffset.Lookup lookup, long unitMillis) {
                super(unitMillis);
                this.lookup = lookup;
            }

            @Override
            public long round(long utcMillis) {
                LocalTimeOffset offset = this.lookup.lookup(utcMillis);
                long roundedLocalMillis = TimeUnitRounding.this.unit.roundFloor(offset.utcToLocalTime(utcMillis));
                return offset.localToUtc(roundedLocalMillis, this);
            }

            @Override
            public long inGap(long localMillis, LocalTimeOffset.Gap gap) {
                return gap.previous().localToUtc(TimeUnitRounding.this.unit.roundFloor(gap.firstMissingLocalTime() - 1L), this);
            }

            @Override
            public long beforeGap(long localMillis, LocalTimeOffset.Gap gap) {
                return this.inGap(localMillis, gap);
            }

            @Override
            public long inOverlap(long localMillis, LocalTimeOffset.Overlap overlap) {
                return overlap.localToUtcInThisOffset(localMillis);
            }

            @Override
            public long beforeOverlap(long localMillis, LocalTimeOffset.Overlap overlap) {
                if (overlap.firstNonOverlappingLocalTime() - overlap.firstOverlappingLocalTime() >= this.unitMillis) {
                    return overlap.localToUtcInThisOffset(localMillis);
                }
                return overlap.previous().localToUtc(localMillis, this);
            }
        }

        private class JavaTimeToMidnightRounding
        extends TimeUnitPreparedRounding {
            private JavaTimeToMidnightRounding() {
            }

            @Override
            public long round(long utcMillis) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(utcMillis), TimeUnitRounding.this.timeZone);
                LocalDateTime localMidnight = TimeUnitRounding.this.truncateLocalDateTime(localDateTime);
                return this.firstTimeOnDay(localMidnight);
            }

            @Override
            public long nextRoundingValue(long utcMillis) {
                LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(utcMillis), TimeUnitRounding.this.timeZone);
                LocalDateTime earlierLocalMidnight = TimeUnitRounding.this.truncateLocalDateTime(localDateTime);
                LocalDateTime localMidnight = this.nextRelevantMidnight(earlierLocalMidnight);
                return this.firstTimeOnDay(localMidnight);
            }

            @Override
            protected Prepared maybeUseArray(long minUtcMillis, long maxUtcMillis, int max) {
                return this;
            }

            private long firstTimeOnDay(LocalDateTime localMidnight) {
                assert (localMidnight.toLocalTime().equals(LocalTime.of(0, 0, 0))) : "firstTimeOnDay should only be called at midnight";
                List<ZoneOffset> currentOffsets = TimeUnitRounding.this.timeZone.getRules().getValidOffsets(localMidnight);
                if (!currentOffsets.isEmpty()) {
                    ZoneOffset firstOffset = currentOffsets.get(0);
                    OffsetDateTime offsetMidnight = localMidnight.atOffset(firstOffset);
                    return offsetMidnight.toInstant().toEpochMilli();
                }
                ZoneOffsetTransition zoneOffsetTransition = TimeUnitRounding.this.timeZone.getRules().getTransition(localMidnight);
                return zoneOffsetTransition.getInstant().toEpochMilli();
            }

            private LocalDateTime nextRelevantMidnight(LocalDateTime localMidnight) {
                assert (localMidnight.toLocalTime().equals(LocalTime.MIDNIGHT)) : "nextRelevantMidnight should only be called at midnight";
                switch (TimeUnitRounding.this.unit.ordinal()) {
                    case 4: {
                        return localMidnight.plus(1L, ChronoUnit.DAYS);
                    }
                    case 0: {
                        return localMidnight.plus(7L, ChronoUnit.DAYS);
                    }
                    case 3: {
                        return localMidnight.plus(1L, ChronoUnit.MONTHS);
                    }
                    case 2: {
                        return localMidnight.plus(3L, ChronoUnit.MONTHS);
                    }
                    case 1: {
                        return localMidnight.plus(1L, ChronoUnit.YEARS);
                    }
                }
                throw new IllegalArgumentException("Unknown round-to-midnight unit: " + String.valueOf((Object)TimeUnitRounding.this.unit));
            }
        }

        private class JavaTimeNotToMidnightRounding
        extends AbstractNotToMidnightRounding {
            JavaTimeNotToMidnightRounding(long unitMillis) {
                super(unitMillis);
            }

            @Override
            public long round(long utcMillis) {
                Instant instant = Instant.ofEpochMilli(utcMillis);
                ZoneRules rules = TimeUnitRounding.this.timeZone.getRules();
                while (true) {
                    Instant truncatedTime = this.truncateAsLocalTime(instant, rules);
                    ZoneOffsetTransition previousTransition = rules.previousTransition(instant);
                    if (previousTransition == null) {
                        return truncatedTime.toEpochMilli();
                    }
                    Instant previousTransitionInstant = previousTransition.getInstant();
                    if (truncatedTime != null && previousTransitionInstant.compareTo(truncatedTime) < 1) {
                        return truncatedTime.toEpochMilli();
                    }
                    instant = previousTransitionInstant.minusNanos(1000000L);
                }
            }

            private Instant truncateAsLocalTime(Instant instant, ZoneRules rules) {
                assert (!TimeUnitRounding.this.unitRoundsToMidnight) : "truncateAsLocalTime should not be called if unitRoundsToMidnight";
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, TimeUnitRounding.this.timeZone);
                LocalDateTime truncatedLocalDateTime = TimeUnitRounding.this.truncateLocalDateTime(localDateTime);
                List<ZoneOffset> currentOffsets = rules.getValidOffsets(truncatedLocalDateTime);
                if (!currentOffsets.isEmpty()) {
                    for (int offsetIndex = currentOffsets.size() - 1; offsetIndex >= 0; --offsetIndex) {
                        Instant result = truncatedLocalDateTime.atOffset(currentOffsets.get(offsetIndex)).toInstant();
                        if (result.isAfter(instant)) continue;
                        return result;
                    }
                    assert (false) : "rounded time not found for " + String.valueOf(instant) + " with " + String.valueOf(this);
                    return null;
                }
                return null;
            }
        }

        private abstract class AbstractNotToMidnightRounding
        extends TimeUnitPreparedRounding {
            protected final long unitMillis;

            AbstractNotToMidnightRounding(long unitMillis) {
                this.unitMillis = unitMillis;
            }

            @Override
            public final long nextRoundingValue(long utcMillis) {
                long roundedAfterOneIncrement = this.round(utcMillis + this.unitMillis);
                if (utcMillis < roundedAfterOneIncrement) {
                    return roundedAfterOneIncrement;
                }
                return this.round(utcMillis + 2L * this.unitMillis);
            }
        }
    }

    static class TimeIntervalRounding
    extends Rounding {
        static final byte ID = 2;
        private final long interval;
        private final ZoneId timeZone;

        TimeIntervalRounding(long interval, ZoneId timeZone) {
            if (interval < 1L) {
                throw new IllegalArgumentException("Zero or negative time interval not supported");
            }
            this.interval = interval;
            this.timeZone = timeZone;
        }

        TimeIntervalRounding(StreamInput in) throws IOException {
            this(in.readVLong(), in.getVersion().onOrAfter(LegacyESVersion.V_7_0_0) ? in.readZoneId() : DateUtils.of(in.readString()));
        }

        @Override
        public void innerWriteTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_0_0)) {
                out.writeZoneId(this.timeZone);
            } else {
                out.writeString(DateUtils.zoneIdToDateTimeZone(this.timeZone).getID());
            }
        }

        @Override
        public byte id() {
            return 2;
        }

        @Override
        public Prepared prepare(long minUtcMillis, long maxUtcMillis) {
            long minLookup = minUtcMillis - this.interval;
            long maxLookup = maxUtcMillis;
            LocalTimeOffset.Lookup lookup = LocalTimeOffset.lookup(this.timeZone, minLookup, maxLookup);
            if (lookup == null) {
                return this.prepareJavaTime();
            }
            LocalTimeOffset fixedOffset = lookup.fixedInRange(minLookup, maxLookup);
            if (fixedOffset != null) {
                return new FixedRounding(fixedOffset);
            }
            return new VariableRounding(lookup);
        }

        @Override
        public Prepared prepareForUnknown() {
            LocalTimeOffset offset = LocalTimeOffset.fixedOffset(this.timeZone);
            if (offset != null) {
                return new FixedRounding(offset);
            }
            return this.prepareJavaTime();
        }

        @Override
        Prepared prepareJavaTime() {
            return new JavaTimeRounding();
        }

        @Override
        public long offset() {
            return 0L;
        }

        @Override
        public Rounding withoutOffset() {
            return this;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.interval, this.timeZone);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TimeIntervalRounding other = (TimeIntervalRounding)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.timeZone, other.timeZone);
        }

        public String toString() {
            return "Rounding[" + this.interval + " in " + String.valueOf(this.timeZone) + "]";
        }

        @Override
        public boolean isUTC() {
            return "Z".equals(this.timeZone.getDisplayName(TextStyle.FULL, Locale.ENGLISH));
        }

        private long roundKey(long value, long interval) {
            if (value < 0L) {
                return (value - interval + 1L) / interval;
            }
            return value / interval;
        }

        private class FixedRounding
        extends TimeIntervalPreparedRounding {
            private final LocalTimeOffset offset;

            FixedRounding(LocalTimeOffset offset) {
                this.offset = offset;
            }

            @Override
            public long round(long utcMillis) {
                return this.offset.localToUtcInThisOffset(TimeIntervalRounding.this.roundKey(this.offset.utcToLocalTime(utcMillis), TimeIntervalRounding.this.interval) * TimeIntervalRounding.this.interval);
            }

            @Override
            public long nextRoundingValue(long utcMillis) {
                return new JavaTimeRounding().nextRoundingValue(utcMillis);
            }
        }

        private class VariableRounding
        extends TimeIntervalPreparedRounding
        implements LocalTimeOffset.Strategy {
            private final LocalTimeOffset.Lookup lookup;

            VariableRounding(LocalTimeOffset.Lookup lookup) {
                this.lookup = lookup;
            }

            @Override
            public long round(long utcMillis) {
                LocalTimeOffset offset = this.lookup.lookup(utcMillis);
                return offset.localToUtc(TimeIntervalRounding.this.roundKey(offset.utcToLocalTime(utcMillis), TimeIntervalRounding.this.interval) * TimeIntervalRounding.this.interval, this);
            }

            @Override
            public long nextRoundingValue(long utcMillis) {
                return new JavaTimeRounding().nextRoundingValue(utcMillis);
            }

            @Override
            public long inGap(long localMillis, LocalTimeOffset.Gap gap) {
                return gap.startUtcMillis();
            }

            @Override
            public long beforeGap(long localMillis, LocalTimeOffset.Gap gap) {
                return gap.previous().localToUtc(localMillis, this);
            }

            @Override
            public long inOverlap(long localMillis, LocalTimeOffset.Overlap overlap) {
                return overlap.localToUtcInThisOffset(localMillis);
            }

            @Override
            public long beforeOverlap(long localMillis, LocalTimeOffset.Overlap overlap) {
                return overlap.previous().localToUtc(TimeIntervalRounding.this.roundKey(overlap.firstNonOverlappingLocalTime() - 1L, TimeIntervalRounding.this.interval) * TimeIntervalRounding.this.interval, this);
            }
        }

        private class JavaTimeRounding
        extends TimeIntervalPreparedRounding {
            private JavaTimeRounding() {
            }

            @Override
            public long round(long utcMillis) {
                Instant utcInstant = Instant.ofEpochMilli(utcMillis);
                LocalDateTime rawLocalDateTime = LocalDateTime.ofInstant(utcInstant, TimeIntervalRounding.this.timeZone);
                long localMillis = utcMillis + (long)(TimeIntervalRounding.this.timeZone.getRules().getOffset(utcInstant).getTotalSeconds() * 1000);
                assert (localMillis == rawLocalDateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
                long roundedMillis = TimeIntervalRounding.this.roundKey(localMillis, TimeIntervalRounding.this.interval) * TimeIntervalRounding.this.interval;
                LocalDateTime roundedLocalDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(roundedMillis), ZoneOffset.UTC);
                List<ZoneOffset> currentOffsets = TimeIntervalRounding.this.timeZone.getRules().getValidOffsets(roundedLocalDateTime);
                if (!currentOffsets.isEmpty()) {
                    ZoneOffsetTransition previousTransition = TimeIntervalRounding.this.timeZone.getRules().previousTransition(utcInstant.plusMillis(1L));
                    for (int offsetIndex = currentOffsets.size() - 1; 0 <= offsetIndex; --offsetIndex) {
                        OffsetDateTime offsetTime = roundedLocalDateTime.atOffset(currentOffsets.get(offsetIndex));
                        Instant offsetInstant = offsetTime.toInstant();
                        if (previousTransition != null && offsetInstant.isBefore(previousTransition.getInstant())) {
                            return this.round(previousTransition.getInstant().toEpochMilli() - 1L);
                        }
                        if (utcInstant.isBefore(offsetTime.toInstant())) continue;
                        return offsetInstant.toEpochMilli();
                    }
                    OffsetDateTime offsetTime = roundedLocalDateTime.atOffset(currentOffsets.get(0));
                    Instant offsetInstant = offsetTime.toInstant();
                    assert (false) : String.valueOf(this) + " failed to round " + utcMillis + " down: " + String.valueOf(offsetInstant) + " is the earliest possible";
                    return offsetInstant.toEpochMilli();
                }
                ZoneOffsetTransition zoneOffsetTransition = TimeIntervalRounding.this.timeZone.getRules().getTransition(roundedLocalDateTime);
                return zoneOffsetTransition.getInstant().toEpochMilli();
            }

            @Override
            public long nextRoundingValue(long utcMillis) {
                long prevRound = this.round(utcMillis);
                long increment = TimeIntervalRounding.this.interval;
                long from = prevRound;
                int iterations = 0;
                while (++iterations < 100) {
                    boolean tooHigh;
                    boolean highEnough;
                    long rounded = this.round(from += increment);
                    boolean bl = highEnough = rounded > prevRound;
                    if (!highEnough) {
                        if (increment >= 0L) continue;
                        increment = -increment / 2L;
                        continue;
                    }
                    long roundedRoundedDown = this.round(rounded - 1L);
                    boolean bl2 = tooHigh = roundedRoundedDown > prevRound;
                    if (tooHigh) {
                        if (increment <= 0L) continue;
                        increment = -increment / 2L;
                        continue;
                    }
                    assert (highEnough && !tooHigh);
                    assert (roundedRoundedDown == prevRound);
                    if (iterations > 3 && logger.isDebugEnabled()) {
                        logger.debug("Iterated {} time for {} using {}", (Object)iterations, (Object)utcMillis, (Object)TimeIntervalRounding.this.toString());
                    }
                    return rounded;
                }
                assert (false) : String.format(Locale.ROOT, "Expected to find the rounding in 100 iterations but didn't for [%d] with [%s]", utcMillis, TimeIntervalRounding.this.toString());
                logger.debug("Expected to find the rounding in 100 iterations but didn't for {} using {}", (Object)utcMillis, (Object)TimeIntervalRounding.this.toString());
                return this.round(from);
            }
        }

        private abstract class TimeIntervalPreparedRounding
        implements Prepared {
            private TimeIntervalPreparedRounding() {
            }

            @Override
            public double roundingSize(long utcMillis, DateTimeUnit timeUnit) {
                if (timeUnit.isMillisBased) {
                    return (double)TimeIntervalRounding.this.interval / (double)timeUnit.ratio;
                }
                throw new IllegalArgumentException("Cannot use month-based rate unit [" + timeUnit.shortName + "] with fixed interval based histogram, only week, day, hour, minute and second are supported for this histogram");
            }
        }
    }

    static class OffsetRounding
    extends Rounding {
        static final byte ID = 3;
        private final Rounding delegate;
        private final long offset;

        OffsetRounding(Rounding delegate, long offset) {
            this.delegate = delegate;
            this.offset = offset;
        }

        OffsetRounding(StreamInput in) throws IOException {
            this.delegate = Rounding.read(in);
            this.offset = in.readZLong();
        }

        @Override
        public void innerWriteTo(StreamOutput out) throws IOException {
            if (out.getVersion().before(LegacyESVersion.V_7_6_0)) {
                throw new IllegalArgumentException("Offset rounding not supported before 7.6.0");
            }
            this.delegate.writeTo(out);
            out.writeZLong(this.offset);
        }

        @Override
        public byte id() {
            return 3;
        }

        @Override
        public Prepared prepare(long minUtcMillis, long maxUtcMillis) {
            return this.wrapPreparedRounding(this.delegate.prepare(minUtcMillis - this.offset, maxUtcMillis - this.offset));
        }

        @Override
        public Prepared prepareForUnknown() {
            return this.wrapPreparedRounding(this.delegate.prepareForUnknown());
        }

        @Override
        Prepared prepareJavaTime() {
            return this.wrapPreparedRounding(this.delegate.prepareJavaTime());
        }

        private Prepared wrapPreparedRounding(final Prepared delegatePrepared) {
            return new Prepared(){

                @Override
                public long round(long utcMillis) {
                    return delegatePrepared.round(utcMillis - offset) + offset;
                }

                @Override
                public long nextRoundingValue(long utcMillis) {
                    return delegatePrepared.nextRoundingValue(utcMillis - offset) + offset;
                }

                @Override
                public double roundingSize(long utcMillis, DateTimeUnit timeUnit) {
                    return delegatePrepared.roundingSize(utcMillis, timeUnit);
                }
            };
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public Rounding withoutOffset() {
            return this.delegate;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.delegate, this.offset);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OffsetRounding other = (OffsetRounding)obj;
            return this.delegate.equals(other.delegate) && this.offset == other.offset;
        }

        public String toString() {
            return String.valueOf(this.delegate) + " offset by " + this.offset;
        }

        @Override
        public boolean isUTC() {
            return this.delegate.isUTC();
        }
    }

    private static class ArrayRounding
    implements Prepared {
        private final Roundable roundable;
        private final Prepared delegate;

        public ArrayRounding(Roundable roundable, Prepared delegate) {
            this.roundable = roundable;
            this.delegate = delegate;
        }

        @Override
        public long round(long utcMillis) {
            return this.roundable.floor(utcMillis);
        }

        @Override
        public long nextRoundingValue(long utcMillis) {
            return this.delegate.nextRoundingValue(utcMillis);
        }

        @Override
        public double roundingSize(long utcMillis, DateTimeUnit timeUnit) {
            return this.delegate.roundingSize(utcMillis, timeUnit);
        }
    }

    private abstract class PreparedRounding
    implements Prepared {
        private static final int DEFAULT_ARRAY_ROUNDING_MAX_THRESHOLD = 128;

        private PreparedRounding() {
        }

        protected Prepared maybeUseArray(long minUtcMillis, long maxUtcMillis, int max) {
            long[] values = new long[1];
            long rounded = this.round(minUtcMillis);
            int i = 0;
            values[i++] = rounded;
            while ((rounded = this.nextRoundingValue(rounded)) <= maxUtcMillis) {
                if (i >= max) {
                    return this;
                }
                assert (values[i - 1] == this.round(rounded - 1L));
                values = ArrayUtil.grow(values, i + 1);
                values[i++] = rounded;
            }
            return new ArrayRounding(RoundableFactory.create(values, i), this);
        }
    }
}

