/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.breaker;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.common.breaker.ResponseLimitSettings;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;

public class ResponseLimitBreachedException
extends OpenSearchException {
    private final int responseLimit;
    private final ResponseLimitSettings.LimitEntity limitEntity;

    public ResponseLimitBreachedException(StreamInput in) throws IOException {
        super(in);
        this.responseLimit = in.readVInt();
        this.limitEntity = in.readEnum(ResponseLimitSettings.LimitEntity.class);
    }

    public ResponseLimitBreachedException(String msg, int responseLimit, ResponseLimitSettings.LimitEntity limitEntity) {
        super(msg, new Object[0]);
        this.responseLimit = responseLimit;
        this.limitEntity = limitEntity;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.responseLimit);
        out.writeEnum(this.limitEntity);
    }

    public int getResponseLimit() {
        return this.responseLimit;
    }

    public ResponseLimitSettings.LimitEntity getLimitEntity() {
        return this.limitEntity;
    }

    @Override
    public RestStatus status() {
        return RestStatus.TOO_MANY_REQUESTS;
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("response_limit", this.responseLimit);
        builder.field("limit_entity", (Object)this.limitEntity);
    }
}

