/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToLongBiFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.CacheLoader;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalNotification;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalReason;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.Tuple;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ReleasableLock;

@PublicApi(since="1.0.0")
public class Cache<K, V> {
    private long expireAfterAccessNanos = -1L;
    private boolean entriesExpireAfterAccess;
    private long expireAfterWriteNanos = -1L;
    private boolean entriesExpireAfterWrite;
    private int count = 0;
    private long weight = 0L;
    private long maximumWeight = -1L;
    private ToLongBiFunction<K, V> weigher = (k, v) -> 1L;
    private RemovalListener<K, V> removalListener = notification -> {};
    private final int numberOfSegments;
    public static final int NUMBER_OF_SEGMENTS = 256;
    private final CacheSegment<K, V>[] segments;
    Entry<K, V> head;
    Entry<K, V> tail;
    private final ReleasableLock lruLock = new ReleasableLock(new ReentrantLock());
    private final Consumer<CompletableFuture<Entry<K, V>>> invalidationConsumer = f -> {
        try {
            Entry entry = (Entry)f.get();
            try (ReleasableLock ignored = this.lruLock.acquire();){
                this.delete(entry, RemovalReason.INVALIDATED);
            }
        }
        catch (ExecutionException entry) {
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    };

    Cache(int numberOfSegments) {
        this.numberOfSegments = numberOfSegments != -1 ? numberOfSegments : 256;
        this.segments = new CacheSegment[this.numberOfSegments];
        for (int i = 0; i < this.numberOfSegments; ++i) {
            this.segments[i] = new CacheSegment();
        }
    }

    void setExpireAfterAccessNanos(long expireAfterAccessNanos) {
        if (expireAfterAccessNanos <= 0L) {
            throw new IllegalArgumentException("expireAfterAccessNanos <= 0");
        }
        this.expireAfterAccessNanos = expireAfterAccessNanos;
        this.entriesExpireAfterAccess = true;
    }

    long getExpireAfterAccessNanos() {
        return this.expireAfterAccessNanos;
    }

    void setExpireAfterWriteNanos(long expireAfterWriteNanos) {
        if (expireAfterWriteNanos <= 0L) {
            throw new IllegalArgumentException("expireAfterWriteNanos <= 0");
        }
        this.expireAfterWriteNanos = expireAfterWriteNanos;
        this.entriesExpireAfterWrite = true;
    }

    long getExpireAfterWriteNanos() {
        return this.expireAfterWriteNanos;
    }

    void setMaximumWeight(long maximumWeight) {
        if (maximumWeight < 0L) {
            throw new IllegalArgumentException("maximumWeight < 0");
        }
        this.maximumWeight = maximumWeight;
    }

    void setWeigher(ToLongBiFunction<K, V> weigher) {
        Objects.requireNonNull(weigher);
        this.weigher = weigher;
    }

    void setRemovalListener(RemovalListener<K, V> removalListener) {
        Objects.requireNonNull(removalListener);
        this.removalListener = removalListener;
    }

    protected long now() {
        return this.entriesExpireAfterAccess || this.entriesExpireAfterWrite ? System.nanoTime() : 0L;
    }

    int getNumberOfSegments() {
        return this.numberOfSegments;
    }

    public V get(K key) {
        return this.get(key, this.now(), e -> {});
    }

    private V get(K key, long now, Consumer<Entry<K, V>> onExpiration) {
        CacheSegment segment = this.getCacheSegment(key);
        Entry<K, V> entry = segment.get(key, now, e -> this.isExpired((Entry<K, V>)e, now), onExpiration);
        if (entry == null) {
            return null;
        }
        List<RemovalNotification<K, V>> removalNotifications = this.promote(entry, now).v2();
        if (!removalNotifications.isEmpty()) {
            for (RemovalNotification<K, V> removalNotification : removalNotifications) {
                this.removalListener.onRemoval(removalNotification);
            }
        }
        return entry.value;
    }

    public V computeIfAbsent(K key, CacheLoader<K, V> loader) throws ExecutionException {
        long now = this.now();
        V value = this.get(key, now, e -> {
            try (ReleasableLock ignored = this.lruLock.acquire();){
                this.evictEntry((Entry<K, V>)e);
            }
        });
        if (value == null) {
            value = this.compute(key, loader);
        }
        return value;
    }

    private V compute(K key, CacheLoader<K, V> loader) throws ExecutionException {
        Object value;
        CompletionStage completableValue;
        CompletableFuture<Entry<K, V>> future;
        long now = this.now();
        CacheSegment<K, V> segment = this.getCacheSegment(key);
        CompletableFuture completableFuture = new CompletableFuture();
        try (ReleasableLock ignored = segment.writeLock.acquire();){
            future = segment.map.putIfAbsent(key, completableFuture);
        }
        BiFunction<Entry, Throwable, Object> handler = (ok, ex) -> {
            if (ok != null) {
                List<Object> removalNotifications = new ArrayList();
                try (ReleasableLock ignored = this.lruLock.acquire();){
                    removalNotifications = this.promote((Entry<K, V>)ok, now).v2();
                }
                if (!removalNotifications.isEmpty()) {
                    for (RemovalNotification removalNotification : removalNotifications) {
                        this.removalListener.onRemoval(removalNotification);
                    }
                }
                return ok.value;
            }
            try (ReleasableLock ignored = segment.writeLock.acquire();){
                CompletableFuture sanity = segment.map.get(key);
                if (sanity != null && sanity.isCompletedExceptionally()) {
                    segment.map.remove(key);
                }
            }
            return null;
        };
        if (future == null) {
            V loaded;
            future = completableFuture;
            completableValue = future.handle(handler);
            try {
                loaded = loader.load(key);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                throw new ExecutionException(e);
            }
            if (loaded == null) {
                NullPointerException npe = new NullPointerException("loader returned a null value");
                future.completeExceptionally(npe);
                throw new ExecutionException(npe);
            }
            future.complete(new Entry<K, V>(key, loaded, now));
        } else {
            completableValue = future.handle(handler);
        }
        try {
            value = ((CompletableFuture)completableValue).get();
            if (future.isCompletedExceptionally()) {
                future.get();
                throw new IllegalStateException("the future was completed exceptionally but no exception was thrown");
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        return (V)value;
    }

    public void put(K key, V value) {
        long now = this.now();
        this.put(key, value, now);
    }

    private void put(K key, V value, long now) {
        CacheSegment<K, V> segment = this.getCacheSegment(key);
        Tuple<Entry<K, V>, Entry<K, V>> tuple = segment.put(key, value, now);
        boolean replaced = false;
        List<Object> removalNotifications = new ArrayList();
        try (ReleasableLock ignored = this.lruLock.acquire();){
            if (tuple.v2() != null && tuple.v2().state == State.EXISTING && this.unlink(tuple.v2())) {
                replaced = true;
            }
            removalNotifications = this.promote(tuple.v1(), now).v2();
        }
        if (replaced) {
            removalNotifications.add(new RemovalNotification(tuple.v2().key, tuple.v2().value, RemovalReason.REPLACED));
        }
        if (!removalNotifications.isEmpty()) {
            for (RemovalNotification removalNotification : removalNotifications) {
                this.removalListener.onRemoval(removalNotification);
            }
        }
    }

    public void invalidate(K key) {
        CacheSegment<K, V> segment = this.getCacheSegment(key);
        segment.remove(key, this.invalidationConsumer);
    }

    public void invalidate(K key, V value) {
        CacheSegment<K, V> segment = this.getCacheSegment(key);
        segment.remove(key, value, this.invalidationConsumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll() {
        Entry<K, V> h;
        boolean[] haveSegmentLock = new boolean[this.numberOfSegments];
        try {
            for (int i = 0; i < this.numberOfSegments; ++i) {
                this.segments[i].segmentLock.writeLock().lock();
                haveSegmentLock[i] = true;
            }
            try (ReleasableLock ignored = this.lruLock.acquire();){
                h = this.head;
                Arrays.stream(this.segments).forEach(segment -> {
                    segment.map = new HashMap();
                });
                Entry<K, V> current = this.head;
                while (current != null) {
                    current.state = State.DELETED;
                    current = current.after;
                }
                this.tail = null;
                this.head = null;
                this.count = 0;
                this.weight = 0L;
            }
        }
        catch (Throwable throwable) {
            for (int i = this.numberOfSegments - 1; i >= 0; --i) {
                if (!haveSegmentLock[i]) continue;
                this.segments[i].segmentLock.writeLock().unlock();
            }
            throw throwable;
        }
        for (int i = this.numberOfSegments - 1; i >= 0; --i) {
            if (!haveSegmentLock[i]) continue;
            this.segments[i].segmentLock.writeLock().unlock();
        }
        while (h != null) {
            this.removalListener.onRemoval(new RemovalNotification(h.key, h.value, RemovalReason.INVALIDATED));
            h = h.after;
        }
    }

    public void refresh() {
        long now = this.now();
        try (ReleasableLock ignored = this.lruLock.acquire();){
            this.evict(now);
        }
    }

    public int count() {
        return this.count;
    }

    public long weight() {
        return this.weight;
    }

    public Iterable<K> keys() {
        return () -> new Iterator<K>(){
            private CacheIterator iterator;
            {
                this.iterator = new CacheIterator(Cache.this.head);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public K next() {
                return ((Entry)this.iterator.next()).key;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public Iterable<V> values() {
        return () -> new Iterator<V>(){
            private CacheIterator iterator;
            {
                this.iterator = new CacheIterator(Cache.this.head);
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public V next() {
                return ((Entry)this.iterator.next()).value;
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    public CacheStats stats() {
        long hits = 0L;
        long misses = 0L;
        long evictions = 0L;
        for (int i = 0; i < this.segments.length; ++i) {
            hits += this.segments[i].segmentStats.hits.longValue();
            misses += this.segments[i].segmentStats.misses.longValue();
            evictions += this.segments[i].segmentStats.evictions.longValue();
        }
        return new CacheStats(hits, misses, evictions);
    }

    private Tuple<Boolean, List<RemovalNotification<K, V>>> promote(Entry<K, V> entry, long now) {
        boolean promoted = true;
        ArrayList removalNotifications = new ArrayList();
        try (ReleasableLock ignored = this.lruLock.acquire();){
            switch (entry.state.ordinal()) {
                case 2: {
                    promoted = false;
                    break;
                }
                case 1: {
                    this.relinkAtHead(entry);
                    break;
                }
                case 0: {
                    this.linkAtHead(entry);
                }
            }
            if (promoted) {
                while (this.tail != null && this.shouldPrune(this.tail, now)) {
                    Entry<K, V> entryToBeRemoved = this.tail;
                    CacheSegment segment = this.getCacheSegment(entryToBeRemoved.key);
                    if (segment != null) {
                        segment.remove(entryToBeRemoved.key, entryToBeRemoved.value, f -> {});
                    }
                    if (!this.unlink(entryToBeRemoved)) continue;
                    removalNotifications.add(new RemovalNotification(entryToBeRemoved.key, entryToBeRemoved.value, RemovalReason.EVICTED));
                }
            }
        }
        return new Tuple<Boolean, List<RemovalNotification<K, V>>>(promoted, removalNotifications);
    }

    private void evict(long now) {
        assert (this.lruLock.isHeldByCurrentThread());
        while (this.tail != null && this.shouldPrune(this.tail, now)) {
            this.evictEntry(this.tail);
        }
    }

    private void evictEntry(Entry<K, V> entry) {
        assert (this.lruLock.isHeldByCurrentThread());
        CacheSegment segment = this.getCacheSegment(entry.key);
        if (segment != null) {
            segment.remove(entry.key, entry.value, f -> {});
        }
        this.delete(entry, RemovalReason.EVICTED);
    }

    private void delete(Entry<K, V> entry, RemovalReason removalReason) {
        assert (this.lruLock.isHeldByCurrentThread());
        if (this.unlink(entry)) {
            this.removalListener.onRemoval(new RemovalNotification(entry.key, entry.value, removalReason));
        }
    }

    private boolean shouldPrune(Entry<K, V> entry, long now) {
        return this.exceedsWeight() || this.isExpired(entry, now);
    }

    private boolean exceedsWeight() {
        return this.maximumWeight != -1L && this.weight > this.maximumWeight;
    }

    private boolean isExpired(Entry<K, V> entry, long now) {
        return this.entriesExpireAfterAccess && now - entry.accessTime > this.expireAfterAccessNanos || this.entriesExpireAfterWrite && now - entry.writeTime > this.expireAfterWriteNanos;
    }

    private boolean unlink(Entry<K, V> entry) {
        assert (this.lruLock.isHeldByCurrentThread());
        if (entry.state == State.EXISTING) {
            Entry before = entry.before;
            Entry after = entry.after;
            if (before == null) {
                assert (this.head == entry);
                this.head = after;
                if (this.head != null) {
                    this.head.before = null;
                }
            } else {
                before.after = after;
                entry.before = null;
            }
            if (after == null) {
                assert (this.tail == entry);
                this.tail = before;
                if (this.tail != null) {
                    this.tail.after = null;
                }
            } else {
                after.before = before;
                entry.after = null;
            }
            --this.count;
            this.weight -= this.weigher.applyAsLong(entry.key, entry.value);
            entry.state = State.DELETED;
            return true;
        }
        return false;
    }

    private void linkAtHead(Entry<K, V> entry) {
        assert (this.lruLock.isHeldByCurrentThread());
        Entry<K, V> h = this.head;
        entry.before = null;
        entry.after = this.head;
        this.head = entry;
        if (h == null) {
            this.tail = entry;
        } else {
            h.before = entry;
        }
        ++this.count;
        this.weight += this.weigher.applyAsLong(entry.key, entry.value);
        entry.state = State.EXISTING;
    }

    private void relinkAtHead(Entry<K, V> entry) {
        assert (this.lruLock.isHeldByCurrentThread());
        if (this.head != entry) {
            this.unlink(entry);
            this.linkAtHead(entry);
        }
    }

    public ToLongBiFunction<K, V> getWeigher() {
        return this.weigher;
    }

    private CacheSegment<K, V> getCacheSegment(K key) {
        return this.segments[key.hashCode() & this.numberOfSegments - 1];
    }

    private static class CacheSegment<K, V> {
        ReadWriteLock segmentLock = new ReentrantReadWriteLock();
        ReleasableLock readLock = new ReleasableLock(this.segmentLock.readLock());
        ReleasableLock writeLock = new ReleasableLock(this.segmentLock.writeLock());
        Map<K, CompletableFuture<Entry<K, V>>> map = new HashMap<K, CompletableFuture<Entry<K, V>>>();
        SegmentStats segmentStats = new SegmentStats();

        private CacheSegment() {
        }

        Entry<K, V> get(K key, long now, Predicate<Entry<K, V>> isExpired, Consumer<Entry<K, V>> onExpiration) {
            CompletableFuture<Entry<K, V>> future;
            try (ReleasableLock ignored = this.readLock.acquire();){
                future = this.map.get(key);
            }
            if (future != null) {
                Entry<K, V> entry;
                try {
                    entry = future.get();
                }
                catch (ExecutionException e) {
                    assert (future.isCompletedExceptionally());
                    this.segmentStats.miss();
                    return null;
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                if (isExpired.test(entry)) {
                    this.segmentStats.miss();
                    onExpiration.accept(entry);
                    return null;
                }
                this.segmentStats.hit();
                entry.accessTime = now;
                return entry;
            }
            this.segmentStats.miss();
            return null;
        }

        Tuple<Entry<K, V>, Entry<K, V>> put(K key, V value, long now) {
            Entry<K, V> entry = new Entry<K, V>(key, value, now);
            Entry existing = null;
            try (ReleasableLock ignored = this.writeLock.acquire();){
                try {
                    CompletableFuture<Entry<K, V>> future = this.map.put(key, CompletableFuture.completedFuture(entry));
                    if (future != null) {
                        existing = (Entry)((CompletableFuture)future.handle((ok, ex) -> {
                            if (ok != null) {
                                return ok;
                            }
                            return null;
                        })).get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
            return Tuple.tuple(entry, existing);
        }

        void remove(K key, Consumer<CompletableFuture<Entry<K, V>>> onRemoval) {
            CompletableFuture<Entry<K, V>> future;
            try (ReleasableLock ignored = this.writeLock.acquire();){
                future = this.map.remove(key);
            }
            if (future != null) {
                this.segmentStats.eviction();
                onRemoval.accept(future);
            }
        }

        void remove(K key, V value, Consumer<CompletableFuture<Entry<K, V>>> onRemoval) {
            CompletableFuture<Entry<K, V>> future;
            boolean removed = false;
            try (ReleasableLock ignored = this.writeLock.acquire();){
                future = this.map.get(key);
                try {
                    if (future != null && future.isDone()) {
                        Entry<K, V> entry = future.get();
                        if (Objects.equals(value, entry.value)) {
                            removed = this.map.remove(key, future);
                        }
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (future != null && removed) {
                this.segmentStats.eviction();
                onRemoval.accept(future);
            }
        }

        private static class SegmentStats {
            private final LongAdder hits = new LongAdder();
            private final LongAdder misses = new LongAdder();
            private final LongAdder evictions = new LongAdder();

            private SegmentStats() {
            }

            void hit() {
                this.hits.increment();
            }

            void miss() {
                this.misses.increment();
            }

            void eviction() {
                this.evictions.increment();
            }
        }
    }

    static class Entry<K, V> {
        final K key;
        final V value;
        long writeTime;
        volatile long accessTime;
        Entry<K, V> before;
        Entry<K, V> after;
        State state = State.NEW;

        Entry(K key, V value, long writeTime) {
            this.key = key;
            this.value = value;
            this.writeTime = this.accessTime = writeTime;
        }
    }

    static enum State {
        NEW,
        EXISTING,
        DELETED;

    }

    @PublicApi(since="1.0.0")
    public static class CacheStats {
        private long hits;
        private long misses;
        private long evictions;

        public CacheStats(long hits, long misses, long evictions) {
            this.hits = hits;
            this.misses = misses;
            this.evictions = evictions;
        }

        public long getHits() {
            return this.hits;
        }

        public long getMisses() {
            return this.misses;
        }

        public long getEvictions() {
            return this.evictions;
        }
    }

    private class CacheIterator
    implements Iterator<Entry<K, V>> {
        private Entry<K, V> current = null;
        private Entry<K, V> next;

        CacheIterator(Entry<K, V> head) {
            this.next = head;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry<K, V> next() {
            this.current = this.next;
            this.next = this.next.after;
            return this.current;
        }

        @Override
        public void remove() {
            Entry entry = this.current;
            if (entry != null) {
                CacheSegment segment = Cache.this.getCacheSegment(entry.key);
                segment.remove(entry.key, entry.value, f -> {});
                try (ReleasableLock ignored = Cache.this.lruLock.acquire();){
                    this.current = null;
                    Cache.this.delete(entry, RemovalReason.INVALIDATED);
                }
            }
        }
    }
}

