/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.module;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.ICache;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.service.CacheService;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.store.OpenSearchOnHeapCache;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.CachePlugin;

@ExperimentalApi
public class CacheModule {
    private final Map<String, ICache.Factory> cacheStoreTypeFactories;
    private final CacheService cacheService;
    private final Settings settings;

    public CacheModule(List<CachePlugin> cachePlugins, Settings settings) {
        this.cacheStoreTypeFactories = CacheModule.getCacheStoreTypeFactories(cachePlugins);
        this.settings = settings;
        this.cacheService = new CacheService(this.cacheStoreTypeFactories, settings);
    }

    private static Map<String, ICache.Factory> getCacheStoreTypeFactories(List<CachePlugin> cachePlugins) {
        HashMap<String, ICache.Factory> cacheStoreTypeFactories = new HashMap<String, ICache.Factory>();
        cacheStoreTypeFactories.put("opensearch_onheap", new OpenSearchOnHeapCache.OpenSearchOnHeapCacheFactory());
        for (CachePlugin cachePlugin : cachePlugins) {
            Map<String, ICache.Factory> factoryMap = cachePlugin.getCacheFactoryMap();
            for (Map.Entry<String, ICache.Factory> entry : factoryMap.entrySet()) {
                if (cacheStoreTypeFactories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Cache name: " + entry.getKey() + " is already registered");
            }
        }
        return Collections.unmodifiableMap(cacheStoreTypeFactories);
    }

    public CacheService getCacheService() {
        return this.cacheService;
    }

    Map<String, ICache.Factory> getCacheStoreTypeFactories() {
        return this.cacheStoreTypeFactories;
    }
}

