/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.policy;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchContextId;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.QuerySearchResult;

public class CachedQueryResult {
    private final PolicyValues policyValues;
    private final QuerySearchResult qsr;

    public CachedQueryResult(QuerySearchResult qsr, long tookTimeNanos) {
        this.qsr = qsr;
        this.policyValues = new PolicyValues(tookTimeNanos);
    }

    public static PolicyValues getPolicyValues(BytesReference serializedCQR) throws IOException {
        StreamInput in = serializedCQR.streamInput();
        return new PolicyValues(in);
    }

    public static void loadQSR(BytesReference serializedCQR, QuerySearchResult qsr, ShardSearchContextId id, NamedWriteableRegistry registry) throws IOException {
        NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(serializedCQR.streamInput(), registry);
        PolicyValues pv = new PolicyValues(in);
        qsr.readFromWithId(id, in);
    }

    public void writeToNoId(StreamOutput out) throws IOException {
        this.policyValues.writeTo(out);
        this.qsr.writeToNoId(out);
    }

    @ExperimentalApi
    public static class PolicyValues
    implements Writeable {
        final long tookTimeNanos;

        public PolicyValues(long tookTimeNanos) {
            this.tookTimeNanos = tookTimeNanos;
        }

        public PolicyValues(StreamInput in) throws IOException {
            this.tookTimeNanos = in.readZLong();
        }

        public long getTookTimeNanos() {
            return this.tookTimeNanos;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeZLong(this.tookTimeNanos);
        }
    }
}

