/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.store.builders;

import java.util.function.ToLongBiFunction;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.ExperimentalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.ICache;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.ICacheKey;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.RemovalListener;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;

@ExperimentalApi
public abstract class ICacheBuilder<K, V> {
    private long maxWeightInBytes;
    private ToLongBiFunction<ICacheKey<K>, V> weigher;
    private TimeValue expireAfterAcess;
    private Settings settings;
    private RemovalListener<ICacheKey<K>, V> removalListener;
    private boolean statsTrackingEnabled = true;
    private int numberOfSegments;

    public ICacheBuilder<K, V> setMaximumWeightInBytes(long sizeInBytes) {
        this.maxWeightInBytes = sizeInBytes;
        return this;
    }

    public ICacheBuilder<K, V> setWeigher(ToLongBiFunction<ICacheKey<K>, V> weigher) {
        this.weigher = weigher;
        return this;
    }

    public ICacheBuilder<K, V> setExpireAfterAccess(TimeValue expireAfterAcess) {
        this.expireAfterAcess = expireAfterAcess;
        return this;
    }

    public ICacheBuilder<K, V> setSettings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public ICacheBuilder<K, V> setRemovalListener(RemovalListener<ICacheKey<K>, V> removalListener) {
        this.removalListener = removalListener;
        return this;
    }

    public ICacheBuilder<K, V> setStatsTrackingEnabled(boolean statsTrackingEnabled) {
        this.statsTrackingEnabled = statsTrackingEnabled;
        return this;
    }

    public ICacheBuilder<K, V> setNumberOfSegments(int numberOfSegments) {
        this.numberOfSegments = numberOfSegments;
        return this;
    }

    public long getMaxWeightInBytes() {
        return this.maxWeightInBytes;
    }

    public TimeValue getExpireAfterAcess() {
        return this.expireAfterAcess;
    }

    public int getNumberOfSegments() {
        return this.numberOfSegments;
    }

    public ToLongBiFunction<ICacheKey<K>, V> getWeigher() {
        return this.weigher;
    }

    public RemovalListener<ICacheKey<K>, V> getRemovalListener() {
        return this.removalListener;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean getStatsTrackingEnabled() {
        return this.statsTrackingEnabled;
    }

    public abstract ICache<K, V> build();
}

