/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.cache.store.settings;

import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.cache.CacheType;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.unit.ByteSizeValue;

public class OpenSearchOnHeapCacheSettings {
    public static final Setting.AffixSetting<ByteSizeValue> MAXIMUM_SIZE_IN_BYTES = Setting.suffixKeySetting("opensearch_onheap.size", key -> Setting.memorySizeSetting(key, "1%", Setting.Property.NodeScope));
    public static final Setting.AffixSetting<TimeValue> EXPIRE_AFTER_ACCESS_SETTING = Setting.suffixKeySetting("opensearch_onheap.expire", key -> Setting.positiveTimeSetting(key, TimeValue.MAX_VALUE, Setting.Property.NodeScope));
    public static final String MAXIMUM_SIZE_IN_BYTES_KEY = "maximum_size_in_bytes";
    public static final String EXPIRE_AFTER_ACCESS_KEY = "expire_after_access";
    private static final Map<String, Setting.AffixSetting<?>> KEY_SETTING_MAP = Map.of("maximum_size_in_bytes", MAXIMUM_SIZE_IN_BYTES, "expire_after_access", EXPIRE_AFTER_ACCESS_SETTING);
    public static final Map<CacheType, Map<String, Setting<?>>> CACHE_TYPE_MAP = OpenSearchOnHeapCacheSettings.getCacheTypeMap();

    private static Map<CacheType, Map<String, Setting<?>>> getCacheTypeMap() {
        HashMap cacheTypeMap = new HashMap();
        for (CacheType cacheType : CacheType.values()) {
            HashMap settingMap = new HashMap();
            for (Map.Entry<String, Setting.AffixSetting<?>> entry : KEY_SETTING_MAP.entrySet()) {
                settingMap.put(entry.getKey(), entry.getValue().getConcreteSettingForNamespace(cacheType.getSettingPrefix()));
            }
            cacheTypeMap.put(cacheType, settingMap);
        }
        return cacheTypeMap;
    }

    public static Map<String, Setting<?>> getSettingListForCacheType(CacheType cacheType) {
        Map<String, Setting<?>> cacheTypeSettings = CACHE_TYPE_MAP.get((Object)cacheType);
        if (cacheTypeSettings == null) {
            throw new IllegalArgumentException("No settings exist for cache store name: opensearch_onheapassociated with cache type: " + String.valueOf((Object)cacheType));
        }
        return cacheTypeSettings;
    }
}

