/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.geo.parsers;

import java.io.IOException;
import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchParseException;
import org.graylog.shaded.opensearch2.org.opensearch.common.Explicit;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoPoint;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.GeoShapeType;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.CircleBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.GeometryCollectionBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.builders.ShapeBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.parsers.CoordinateNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.geo.parsers.ShapeParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.DistanceUnit;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentSubParser;
import org.graylog.shaded.opensearch2.org.opensearch.index.mapper.AbstractShapeGeometryFieldMapper;
import org.locationtech.jts.geom.Coordinate;

abstract class GeoJsonParser {
    GeoJsonParser() {
    }

    protected static ShapeBuilder parse(XContentParser parser, AbstractShapeGeometryFieldMapper shapeMapper) throws IOException {
        Enum shapeType = null;
        DistanceUnit.Distance radius = null;
        CoordinateNode coordinateNode = null;
        GeometryCollectionBuilder geometryCollections = null;
        ShapeBuilder.Orientation orientation = shapeMapper == null ? AbstractShapeGeometryFieldMapper.Defaults.ORIENTATION.value() : shapeMapper.orientation();
        Explicit<Boolean> coerce = shapeMapper == null ? AbstractShapeGeometryFieldMapper.Defaults.COERCE : shapeMapper.coerce();
        Explicit<Boolean> ignoreZValue = shapeMapper == null ? AbstractShapeGeometryFieldMapper.Defaults.IGNORE_Z_VALUE : shapeMapper.ignoreZValue();
        String malformedException = null;
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            XContentParser.Token token;
            while ((token = subParser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token != XContentParser.Token.FIELD_NAME) continue;
                String fieldName = subParser.currentName();
                if (ShapeParser.FIELD_TYPE.match(fieldName, subParser.getDeprecationHandler())) {
                    subParser.nextToken();
                    GeoShapeType type = GeoShapeType.forName(subParser.text());
                    if (shapeType != null && !shapeType.equals((Object)type)) {
                        malformedException = String.valueOf(ShapeParser.FIELD_TYPE) + " already parsed as [" + String.valueOf(shapeType) + "] cannot redefine as [" + String.valueOf((Object)type) + "]";
                        continue;
                    }
                    shapeType = type;
                    continue;
                }
                if (ShapeParser.FIELD_COORDINATES.match(fieldName, subParser.getDeprecationHandler())) {
                    subParser.nextToken();
                    CoordinateNode tempNode = GeoJsonParser.parseCoordinates(subParser, ignoreZValue.value());
                    if (coordinateNode != null && tempNode.numDimensions() != coordinateNode.numDimensions()) {
                        throw new OpenSearchParseException("Exception parsing coordinates: number of dimensions do not match", new Object[0]);
                    }
                    coordinateNode = tempNode;
                    continue;
                }
                if (ShapeParser.FIELD_GEOMETRIES.match(fieldName, subParser.getDeprecationHandler())) {
                    if (shapeType == null) {
                        shapeType = GeoShapeType.GEOMETRYCOLLECTION;
                    } else if (!shapeType.equals((Object)GeoShapeType.GEOMETRYCOLLECTION)) {
                        malformedException = "cannot have [" + String.valueOf(ShapeParser.FIELD_GEOMETRIES) + "] with type set to [" + String.valueOf(shapeType) + "]";
                    }
                    subParser.nextToken();
                    geometryCollections = GeoJsonParser.parseGeometries(subParser, shapeMapper);
                    continue;
                }
                if (CircleBuilder.FIELD_RADIUS.match(fieldName, subParser.getDeprecationHandler())) {
                    if (shapeType == null) {
                        shapeType = GeoShapeType.CIRCLE;
                    } else if (shapeType != null && !shapeType.equals((Object)GeoShapeType.CIRCLE)) {
                        malformedException = "cannot have [" + String.valueOf(CircleBuilder.FIELD_RADIUS) + "] with type set to [" + String.valueOf(shapeType) + "]";
                    }
                    subParser.nextToken();
                    radius = DistanceUnit.Distance.parseDistance(subParser.text());
                    continue;
                }
                if (ShapeParser.FIELD_ORIENTATION.match(fieldName, subParser.getDeprecationHandler())) {
                    if (shapeType != null && !(shapeType.equals((Object)GeoShapeType.POLYGON) || shapeType.equals((Object)GeoShapeType.MULTIPOLYGON))) {
                        malformedException = "cannot have [" + String.valueOf(ShapeParser.FIELD_ORIENTATION) + "] with type set to [" + String.valueOf(shapeType) + "]";
                    }
                    subParser.nextToken();
                    orientation = ShapeBuilder.Orientation.fromString(subParser.text());
                    continue;
                }
                subParser.nextToken();
                subParser.skipChildren();
            }
        }
        if (malformedException != null) {
            throw new OpenSearchParseException(malformedException, new Object[0]);
        }
        if (shapeType == null) {
            throw new OpenSearchParseException("shape type not included", new Object[0]);
        }
        if (coordinateNode == null && GeoShapeType.GEOMETRYCOLLECTION != shapeType) {
            throw new OpenSearchParseException("coordinates not included", new Object[0]);
        }
        if (geometryCollections == null && GeoShapeType.GEOMETRYCOLLECTION == shapeType) {
            throw new OpenSearchParseException("geometries not included", new Object[0]);
        }
        if (radius != null && GeoShapeType.CIRCLE != shapeType) {
            throw new OpenSearchParseException("field [{}] is supported for [{}] only", new Object[]{CircleBuilder.FIELD_RADIUS, CircleBuilder.TYPE});
        }
        if (shapeType.equals((Object)GeoShapeType.GEOMETRYCOLLECTION)) {
            return geometryCollections;
        }
        return ((GeoShapeType)shapeType).getBuilder(coordinateNode, radius, orientation, coerce.value());
    }

    private static CoordinateNode parseCoordinates(XContentParser parser, boolean ignoreZValue) throws IOException {
        if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
            parser.skipChildren();
            parser.nextToken();
            throw new OpenSearchParseException("coordinates cannot be specified as objects", new Object[0]);
        }
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_ARRAY && token != XContentParser.Token.END_ARRAY && token != XContentParser.Token.VALUE_NULL) {
            return new CoordinateNode(GeoJsonParser.parseCoordinate(parser, ignoreZValue));
        }
        if (token == XContentParser.Token.VALUE_NULL) {
            throw new IllegalArgumentException("coordinates cannot contain NULL values)");
        }
        ArrayList<CoordinateNode> nodes = new ArrayList<CoordinateNode>();
        while (token != XContentParser.Token.END_ARRAY) {
            CoordinateNode node = GeoJsonParser.parseCoordinates(parser, ignoreZValue);
            if (!nodes.isEmpty() && ((CoordinateNode)nodes.get(0)).numDimensions() != node.numDimensions()) {
                throw new OpenSearchParseException("Exception parsing coordinates: number of dimensions do not match", new Object[0]);
            }
            nodes.add(node);
            token = parser.nextToken();
        }
        return new CoordinateNode(nodes);
    }

    private static Coordinate parseCoordinate(XContentParser parser, boolean ignoreZValue) throws IOException {
        if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new OpenSearchParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lon = parser.doubleValue();
        if (parser.nextToken() != XContentParser.Token.VALUE_NUMBER) {
            throw new OpenSearchParseException("geo coordinates must be numbers", new Object[0]);
        }
        double lat = parser.doubleValue();
        XContentParser.Token token = parser.nextToken();
        double alt = Double.NaN;
        if (token == XContentParser.Token.VALUE_NUMBER) {
            alt = GeoPoint.assertZValue(ignoreZValue, parser.doubleValue());
            parser.nextToken();
        }
        if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
            throw new OpenSearchParseException("geo coordinates greater than 3 dimensions are not supported", new Object[0]);
        }
        return new Coordinate(lon, lat, alt);
    }

    static GeometryCollectionBuilder parseGeometries(XContentParser parser, AbstractShapeGeometryFieldMapper mapper) throws IOException {
        if (parser.currentToken() != XContentParser.Token.START_ARRAY) {
            throw new OpenSearchParseException("geometries must be an array of geojson objects", new Object[0]);
        }
        XContentParser.Token token = parser.nextToken();
        GeometryCollectionBuilder geometryCollection = new GeometryCollectionBuilder();
        while (token != XContentParser.Token.END_ARRAY) {
            ShapeBuilder shapeBuilder = ShapeParser.parse(parser);
            geometryCollection.shape(shapeBuilder);
            token = parser.nextToken();
        }
        return geometryCollection;
    }
}

