/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.inject;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.internal.Errors;
import org.graylog.shaded.opensearch2.org.opensearch.common.inject.spi.Message;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.set.Sets;

@PublicApi(since="1.0.0")
public final class ConfigurationException
extends RuntimeException {
    private final Set<Message> messages;
    private Object partialValue = null;

    public ConfigurationException(Iterable<Message> messages) {
        this.messages = Collections.unmodifiableSet(Sets.newHashSet(messages));
        this.initCause(Errors.getOnlyCause(this.messages));
    }

    public ConfigurationException withPartialValue(Object partialValue) {
        if (this.partialValue != null) {
            String message = String.format(Locale.ROOT, "Can't clobber existing partial value %s with %s", this.partialValue, partialValue);
            throw new IllegalStateException(message);
        }
        ConfigurationException result = new ConfigurationException(this.messages);
        result.partialValue = partialValue;
        return result;
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    public <E> E getPartialValue() {
        return (E)this.partialValue;
    }

    @Override
    public String getMessage() {
        return Errors.format("Guice configuration errors", this.messages);
    }
}

