/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.path;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class PathTrie<T> {
    private static final EnumSet<TrieMatchingMode> EXPLICIT_OR_ROOT_WILDCARD = EnumSet.of(TrieMatchingMode.EXPLICIT_NODES_ONLY, TrieMatchingMode.WILDCARD_ROOT_NODES_ALLOWED);
    private final Decoder decoder;
    private final TrieNode root;
    private T rootValue;
    private static final String SEPARATOR = "/";
    private static final String WILDCARD = "*";

    public PathTrie(Decoder decoder) {
        this.decoder = decoder;
        this.root = new TrieNode(SEPARATOR, null, WILDCARD);
    }

    public void insert(String path, T value) {
        String[] strings = path.split(SEPARATOR);
        if (strings.length == 0) {
            if (this.rootValue != null) {
                throw new IllegalArgumentException("Path [/] already has a value [" + String.valueOf(this.rootValue) + "]");
            }
            this.rootValue = value;
            return;
        }
        int index = 0;
        if (strings[0].isEmpty()) {
            index = 1;
        }
        this.root.insert(strings, index, value);
    }

    public void insertOrUpdate(String path, T value, BiFunction<T, T, T> updater) {
        String[] strings = path.split(SEPARATOR);
        if (strings.length == 0) {
            this.rootValue = this.rootValue != null ? updater.apply(this.rootValue, value) : value;
            return;
        }
        int index = 0;
        if (strings[0].isEmpty()) {
            index = 1;
        }
        this.root.insertOrUpdate(strings, index, value, updater);
    }

    public T retrieve(String path) {
        return this.retrieve(path, null, TrieMatchingMode.WILDCARD_NODES_ALLOWED);
    }

    public T retrieve(String path, Map<String, String> params) {
        return this.retrieve(path, params, TrieMatchingMode.WILDCARD_NODES_ALLOWED);
    }

    public T retrieve(String path, Map<String, String> params, TrieMatchingMode trieMatchingMode) {
        if (path.length() == 0) {
            return this.rootValue;
        }
        String[] strings = path.split(SEPARATOR);
        if (strings.length == 0) {
            return this.rootValue;
        }
        int index = 0;
        if (strings[0].isEmpty()) {
            index = 1;
        }
        return this.root.retrieve(strings, index, params, trieMatchingMode);
    }

    public Iterator<T> retrieveAll(final String path, final Supplier<Map<String, String>> paramSupplier) {
        return new Iterator<T>(){
            private int mode;

            @Override
            public boolean hasNext() {
                return this.mode < TrieMatchingMode.values().length;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("called next() without validating hasNext()! no more modes available");
                }
                return PathTrie.this.retrieve(path, (Map)paramSupplier.get(), TrieMatchingMode.values()[this.mode++]);
            }
        };
    }

    public Iterator<T> retrieveAll() {
        final Stack<TrieNode> stack = new Stack<TrieNode>();
        stack.add(this.root);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                while (!stack.empty()) {
                    TrieNode node = (TrieNode)stack.peek();
                    if (node.value != null) {
                        return true;
                    }
                    this.advance();
                }
                return false;
            }

            @Override
            public T next() {
                while (!stack.empty()) {
                    TrieNode node = this.advance();
                    if (node.value == null) continue;
                    return node.value;
                }
                throw new NoSuchElementException("called next() without validating hasNext()! no more nodes available");
            }

            private TrieNode advance() {
                TrieNode node = (TrieNode)stack.pop();
                stack.addAll(node.children.values());
                return node;
            }
        };
    }

    public static interface Decoder {
        public String decode(String var1);
    }

    public class TrieNode {
        private transient String key;
        private transient T value;
        private final String wildcard;
        private transient String namedWildcard;
        private Map<String, TrieNode> children;

        private TrieNode(String key, T value, String wildcard) {
            this.key = key;
            this.wildcard = wildcard;
            this.value = value;
            this.children = Collections.emptyMap();
            this.namedWildcard = this.isNamedWildcard(key) ? key.substring(key.indexOf(123) + 1, key.indexOf(125)) : null;
        }

        private void updateKeyWithNamedWildcard(String key) {
            this.key = key;
            String newNamedWildcard = key.substring(key.indexOf(123) + 1, key.indexOf(125));
            if (this.namedWildcard != null && !newNamedWildcard.equals(this.namedWildcard)) {
                throw new IllegalArgumentException("Trying to use conflicting wildcard names for same path: " + this.namedWildcard + " and " + newNamedWildcard);
            }
            this.namedWildcard = newNamedWildcard;
        }

        private void addInnerChild(String key, TrieNode child) {
            HashMap<String, TrieNode> newChildren = new HashMap<String, TrieNode>(this.children);
            newChildren.put(key, child);
            this.children = Collections.unmodifiableMap(newChildren);
        }

        private synchronized void insert(String[] path, int index, T value) {
            TrieNode node;
            String token;
            if (index >= path.length) {
                return;
            }
            String key = token = path[index];
            if (this.isNamedWildcard(token)) {
                key = this.wildcard;
            }
            if ((node = this.children.get(key)) == null) {
                Object nodeValue = index == path.length - 1 ? value : null;
                node = new TrieNode(token, nodeValue, this.wildcard);
                this.addInnerChild(key, node);
            } else {
                if (this.isNamedWildcard(token)) {
                    node.updateKeyWithNamedWildcard(token);
                }
                if (index == path.length - 1) {
                    if (node.value != null) {
                        throw new IllegalArgumentException("Path [" + String.join((CharSequence)PathTrie.SEPARATOR, path) + "] already has a value [" + String.valueOf(node.value) + "]");
                    }
                    node.value = value;
                }
            }
            node.insert(path, index + 1, value);
        }

        private synchronized void insertOrUpdate(String[] path, int index, T value, BiFunction<T, T, T> updater) {
            TrieNode node;
            String token;
            if (index >= path.length) {
                return;
            }
            String key = token = path[index];
            if (this.isNamedWildcard(token)) {
                key = this.wildcard;
            }
            if ((node = this.children.get(key)) == null) {
                Object nodeValue = index == path.length - 1 ? value : null;
                node = new TrieNode(token, nodeValue, this.wildcard);
                this.addInnerChild(key, node);
            } else {
                if (this.isNamedWildcard(token)) {
                    node.updateKeyWithNamedWildcard(token);
                }
                if (index == path.length - 1) {
                    node.value = node.value != null ? updater.apply(node.value, value) : value;
                }
            }
            node.insertOrUpdate(path, index + 1, value, updater);
        }

        private boolean isNamedWildcard(String key) {
            return key.indexOf(123) != -1 && key.indexOf(125) != -1;
        }

        private String namedWildcard() {
            return this.namedWildcard;
        }

        private boolean isNamedWildcard() {
            return this.namedWildcard != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public T retrieve(String[] path, int index, Map<String, String> params, TrieMatchingMode trieMatchingMode) {
            boolean usedWildcard;
            if (index >= path.length) {
                return null;
            }
            String token = path[index];
            TrieNode node = this.children.get(token);
            if (node == null) {
                if (trieMatchingMode == TrieMatchingMode.WILDCARD_NODES_ALLOWED) {
                    node = this.children.get(this.wildcard);
                    if (node == null) {
                        return null;
                    }
                    usedWildcard = true;
                } else if (trieMatchingMode == TrieMatchingMode.WILDCARD_ROOT_NODES_ALLOWED && index == 1) {
                    node = this.children.get(this.wildcard);
                    if (node == null) {
                        return null;
                    }
                    usedWildcard = true;
                } else {
                    if (trieMatchingMode != TrieMatchingMode.WILDCARD_LEAF_NODES_ALLOWED || index + 1 != path.length) return null;
                    node = this.children.get(this.wildcard);
                    if (node == null) {
                        return null;
                    }
                    usedWildcard = true;
                }
            } else if (index + 1 == path.length && node.value == null && this.children.get(this.wildcard) != null && !EXPLICIT_OR_ROOT_WILDCARD.contains((Object)trieMatchingMode)) {
                node = this.children.get(this.wildcard);
                usedWildcard = true;
            } else if (index == 1 && node.value == null && this.children.get(this.wildcard) != null && trieMatchingMode == TrieMatchingMode.WILDCARD_ROOT_NODES_ALLOWED) {
                node = this.children.get(this.wildcard);
                usedWildcard = true;
            } else {
                usedWildcard = token.equals(this.wildcard);
            }
            this.put(params, node, token);
            if (index == path.length - 1) {
                return node.value;
            }
            Object nodeValue = node.retrieve(path, index + 1, params, trieMatchingMode);
            if (nodeValue != null || usedWildcard || trieMatchingMode == TrieMatchingMode.EXPLICIT_NODES_ONLY || (node = this.children.get(this.wildcard)) == null) return nodeValue;
            this.put(params, node, token);
            nodeValue = node.retrieve(path, index + 1, params, trieMatchingMode);
            return nodeValue;
        }

        private void put(Map<String, String> params, TrieNode node, String value) {
            if (params != null && node.isNamedWildcard()) {
                params.put(node.namedWildcard(), PathTrie.this.decoder.decode(value));
            }
        }

        public String toString() {
            return this.key;
        }
    }

    static enum TrieMatchingMode {
        EXPLICIT_NODES_ONLY,
        WILDCARD_ROOT_NODES_ALLOWED,
        WILDCARD_LEAF_NODES_ALLOWED,
        WILDCARD_NODES_ALLOWED;

    }
}

