/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.BlobPath;
import org.graylog.shaded.opensearch2.org.opensearch.common.blobstore.stream.write.WritePriority;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWritableEntityStore;
import org.graylog.shaded.opensearch2.org.opensearch.common.remote.RemoteWriteableBlobEntity;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.graylog.shaded.opensearch2.org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

public class RemoteWriteableEntityBlobStore<T, U extends RemoteWriteableBlobEntity<T>>
implements RemoteWritableEntityStore<T, U> {
    private final BlobStoreTransferService transferService;
    private final BlobStoreRepository blobStoreRepository;
    private final String clusterName;
    private final ExecutorService executorService;
    private final String pathToken;

    public RemoteWriteableEntityBlobStore(BlobStoreTransferService blobStoreTransferService, BlobStoreRepository blobStoreRepository, String clusterName, ThreadPool threadPool, String executor, String pathToken) {
        this.transferService = blobStoreTransferService;
        this.blobStoreRepository = blobStoreRepository;
        this.clusterName = clusterName;
        this.executorService = threadPool.executor(executor);
        this.pathToken = pathToken;
    }

    @Override
    public void writeAsync(U entity, ActionListener<Void> listener) {
        try (InputStream inputStream = entity.serialize();){
            BlobPath blobPath = this.getBlobPathForUpload((RemoteWriteableBlobEntity<T>)entity);
            ((RemoteWriteableBlobEntity)entity).setFullBlobName(blobPath);
            this.transferService.uploadBlob(inputStream, this.getBlobPathForUpload((RemoteWriteableBlobEntity<T>)entity), ((RemoteWriteableBlobEntity)entity).getBlobFileName(), WritePriority.URGENT, listener);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    @Override
    public T read(U entity) throws IOException {
        assert (((RemoteWriteableBlobEntity)entity).getFullBlobName() != null);
        try (InputStream inputStream = this.transferService.downloadBlob(this.getBlobPathForDownload((RemoteWriteableBlobEntity<T>)entity), ((RemoteWriteableBlobEntity)entity).getBlobFileName());){
            Object t = entity.deserialize(inputStream);
            return t;
        }
    }

    @Override
    public void readAsync(U entity, ActionListener<T> listener) {
        this.executorService.execute(() -> {
            try {
                listener.onResponse(this.read(entity));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public BlobPath getBlobPathPrefix(String clusterUUID) {
        return this.blobStoreRepository.basePath().add(RemoteWriteableEntityBlobStore.encodeString(this.getClusterName())).add(this.pathToken).add(clusterUUID);
    }

    public BlobPath getBlobPathForUpload(RemoteWriteableBlobEntity<T> obj) {
        BlobPath blobPath = this.getBlobPathPrefix(obj.clusterUUID());
        for (String token : obj.getBlobPathParameters().getPathTokens()) {
            blobPath = blobPath.add(token);
        }
        return obj.getPrefixedPath(blobPath);
    }

    public BlobPath getBlobPathForDownload(RemoteWriteableBlobEntity<T> obj) {
        String[] pathTokens = obj.getBlobPathTokens();
        BlobPath blobPath = new BlobPath();
        if (pathTokens == null || pathTokens.length < 1) {
            return blobPath;
        }
        for (int i = 0; i < pathTokens.length - 1; ++i) {
            blobPath = blobPath.add(pathTokens[i]);
        }
        return blobPath;
    }

    private static String encodeString(String content) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(content.getBytes(StandardCharsets.UTF_8));
    }
}

