/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.round;

import jdk.incubator.vector.LongVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.InternalApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.round.Roundable;

/*
 * Exception performing whole class analysis ignored.
 */
@InternalApi
class BtreeSearcher
implements Roundable {
    private static final VectorSpecies<Long> LONG_VECTOR_SPECIES = LongVector.SPECIES_PREFERRED;
    private static final int LANES = LONG_VECTOR_SPECIES.length();
    private static final int SHIFT = BtreeSearcher.log2((int)LANES);
    private final long[] values;
    private final long minValue;

    BtreeSearcher(long[] values, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("at least one value must be present");
        }
        int blocks = (size + LANES - 1) / LANES;
        int length = 1 + blocks * LANES;
        this.minValue = values[0];
        this.values = new long[length];
        BtreeSearcher.build((long[])values, (int)0, (int)size, (long[])this.values, (int)1);
    }

    private static int build(long[] src, int i, int size, long[] dst, int j) {
        if (j < dst.length) {
            for (int k = 0; k < LANES; ++k) {
                i = BtreeSearcher.build((long[])src, (int)i, (int)size, (long[])dst, (int)(j + (j + k << SHIFT)));
                dst[j + k] = j + k <= size ? src[i++] : Long.MAX_VALUE;
            }
            i = BtreeSearcher.build((long[])src, (int)i, (int)size, (long[])dst, (int)(j + (j + LANES << SHIFT)));
        }
        return i;
    }

    @Override
    public long floor(long key) {
        int j;
        LongVector keyVector = LongVector.broadcast((VectorSpecies)LONG_VECTOR_SPECIES, (long)key);
        int result = 1;
        for (int i = 1; i < this.values.length; i += j << SHIFT) {
            LongVector valuesVector = LongVector.fromArray((VectorSpecies)LONG_VECTOR_SPECIES, (long[])this.values, (int)i);
            j = i + valuesVector.compare(VectorOperators.GT, (Vector)keyVector).firstTrue();
            result = j > i ? j : result;
        }
        assert (result > 1) : "key must be greater than or equal to " + this.minValue;
        return this.values[result - 1];
    }

    private static int log2(int num) {
        if (num <= 0 || (num & num - 1) != 0) {
            throw new IllegalArgumentException(num + " is not a positive power of 2");
        }
        return 32 - Integer.numberOfLeadingZeros(num - 1);
    }
}

