/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.util;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.RamUsageEstimator;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.AbstractBigArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.BigArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.IntArray;

final class BigIntArray
extends AbstractBigArray
implements IntArray {
    private static final BigIntArray ESTIMATOR = new BigIntArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    private int[][] pages;

    BigIntArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(4096, bigArrays, clearOnResize);
        this.size = size;
        this.pages = new int[this.numPages(size)][];
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = this.newIntPage(i);
        }
    }

    @Override
    public int get(long index) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        return this.pages[pageIndex][indexInPage];
    }

    @Override
    public int set(long index, int value) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] page = this.pages[pageIndex];
        int ret = page[indexInPage];
        page[indexInPage] = value;
        return ret;
    }

    @Override
    public int increment(long index, int inc) {
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        int[] nArray = this.pages[pageIndex];
        int n = indexInPage;
        int n2 = nArray[n] + inc;
        nArray[n] = n2;
        return n2;
    }

    @Override
    public void fill(long fromIndex, long toIndex, int value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        int fromPage = this.pageIndex(fromIndex);
        if (fromPage == (toPage = this.pageIndex(toIndex - 1L))) {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.indexInPage(toIndex - 1L) + 1, value);
        } else {
            Arrays.fill(this.pages[fromPage], this.indexInPage(fromIndex), this.pages[fromPage].length, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                Arrays.fill(this.pages[i], value);
            }
            Arrays.fill(this.pages[toPage], 0, this.indexInPage(toIndex - 1L) + 1, value);
        }
    }

    @Override
    protected int numBytesPerElement() {
        return 4;
    }

    @Override
    public void resize(long newSize) {
        int i;
        int numPages = this.numPages(newSize);
        if (numPages > this.pages.length) {
            this.pages = (int[][])Arrays.copyOf(this.pages, ArrayUtil.oversize(numPages, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
        }
        for (i = numPages - 1; i >= 0 && this.pages[i] == null; --i) {
            this.pages[i] = this.newIntPage(i);
        }
        for (i = numPages; i < this.pages.length && this.pages[i] != null; ++i) {
            this.pages[i] = null;
            this.releasePage(i);
        }
        this.size = newSize;
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }
}

