/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.common.util;

import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;

public class FeatureFlags {
    public static final String REMOTE_STORE_MIGRATION_EXPERIMENTAL = "opensearch.experimental.feature.remote_store.migration.enabled";
    public static final String SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY = "opensearch.experimental.feature.searchable_snapshot.extended_compatibility.enabled";
    public static final String EXTENSIONS = "opensearch.experimental.feature.extensions.enabled";
    public static final String TELEMETRY = "opensearch.experimental.feature.telemetry.enabled";
    public static final String DATETIME_FORMATTER_CACHING = "opensearch.experimental.optimization.datetime_formatter_caching.enabled";
    public static final String TIERED_REMOTE_INDEX = "opensearch.experimental.feature.tiered_remote_index.enabled";
    public static final String PLUGGABLE_CACHE = "opensearch.experimental.feature.pluggable.caching.enabled";
    public static final String READER_WRITER_SPLIT_EXPERIMENTAL = "opensearch.experimental.feature.read.write.split.enabled";
    public static final String BACKGROUND_TASK_EXECUTION_EXPERIMENTAL = "opensearch.experimental.feature.task.background.enabled";
    public static final Setting<Boolean> REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING = Setting.boolSetting("opensearch.experimental.feature.remote_store.migration.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> EXTENSIONS_SETTING = Setting.boolSetting("opensearch.experimental.feature.extensions.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> TELEMETRY_SETTING = Setting.boolSetting("opensearch.experimental.feature.telemetry.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> DATETIME_FORMATTER_CACHING_SETTING = Setting.boolSetting("opensearch.experimental.optimization.datetime_formatter_caching.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> TIERED_REMOTE_INDEX_SETTING = Setting.boolSetting("opensearch.experimental.feature.tiered_remote_index.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> PLUGGABLE_CACHE_SETTING = Setting.boolSetting("opensearch.experimental.feature.pluggable.caching.enabled", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> READER_WRITER_SPLIT_EXPERIMENTAL_SETTING = Setting.boolSetting("opensearch.experimental.feature.read.write.split.enabled", false, Setting.Property.NodeScope);
    public static final String APPLICATION_BASED_CONFIGURATION_TEMPLATES = "opensearch.experimental.feature.application_templates.enabled";
    public static final Setting<Boolean> APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING = Setting.boolSetting("opensearch.experimental.feature.application_templates.enabled", false, Setting.Property.NodeScope);
    public static final String STAR_TREE_INDEX = "opensearch.experimental.feature.composite_index.star_tree.enabled";
    public static final Setting<Boolean> STAR_TREE_INDEX_SETTING = Setting.boolSetting("opensearch.experimental.feature.composite_index.star_tree.enabled", false, Setting.Property.NodeScope);
    public static final String APPROXIMATE_POINT_RANGE_QUERY = "opensearch.experimental.feature.approximate_point_range_query.enabled";
    public static final Setting<Boolean> APPROXIMATE_POINT_RANGE_QUERY_SETTING = Setting.boolSetting("opensearch.experimental.feature.approximate_point_range_query.enabled", false, Setting.Property.NodeScope);
    public static final String TERM_VERSION_PRECOMMIT_ENABLE = "opensearch.experimental.optimization.termversion.precommit.enabled";
    public static final Setting<Boolean> TERM_VERSION_PRECOMMIT_ENABLE_SETTING = Setting.boolSetting("opensearch.experimental.optimization.termversion.precommit.enabled", false, Setting.Property.NodeScope);
    private static final List<Setting<Boolean>> ALL_FEATURE_FLAG_SETTINGS = List.of(REMOTE_STORE_MIGRATION_EXPERIMENTAL_SETTING, EXTENSIONS_SETTING, TELEMETRY_SETTING, DATETIME_FORMATTER_CACHING_SETTING, TIERED_REMOTE_INDEX_SETTING, PLUGGABLE_CACHE_SETTING, APPLICATION_BASED_CONFIGURATION_TEMPLATES_SETTING, STAR_TREE_INDEX_SETTING, READER_WRITER_SPLIT_EXPERIMENTAL_SETTING, TERM_VERSION_PRECOMMIT_ENABLE_SETTING);
    private static Settings settings;

    public static void initializeFeatureFlags(Settings openSearchSettings) {
        Settings.Builder settingsBuilder = Settings.builder();
        for (Setting<Boolean> ffSetting : ALL_FEATURE_FLAG_SETTINGS) {
            settingsBuilder = settingsBuilder.put(ffSetting.getKey(), (boolean)openSearchSettings.getAsBoolean(ffSetting.getKey(), ffSetting.getDefault(openSearchSettings)));
        }
        settings = settingsBuilder.build();
    }

    public static boolean isEnabled(String featureFlagName) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlagName))) {
            return true;
        }
        return settings != null && settings.getAsBoolean(featureFlagName, false) != false;
    }

    public static boolean isEnabled(Setting<Boolean> featureFlag) {
        if ("true".equalsIgnoreCase(System.getProperty(featureFlag.getKey()))) {
            return true;
        }
        if (settings != null) {
            return featureFlag.get(settings);
        }
        return featureFlag.getDefault(Settings.EMPTY);
    }

    static {
        Settings.Builder settingsBuilder = Settings.builder();
        for (Setting<Boolean> ffSetting : ALL_FEATURE_FLAG_SETTINGS) {
            settingsBuilder = settingsBuilder.put(ffSetting.getKey(), (boolean)ffSetting.getDefault(Settings.EMPTY));
        }
        settings = settingsBuilder.build();
    }
}

